
<?php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="image-text-hawaii list-style-blue">
  <div class="container">
    <?php
      $rowCount = 0;
    ?>
    <?php if(have_rows('section')): ?>
      <?php while(have_rows('section')): ?>
        <?php
          the_row();
          $title = get_sub_field('title');
          $subtitle = get_sub_field('subtitle');
          $button = get_sub_field('button');
          $body_copy = get_sub_field('body_copy');
          if(!empty(get_sub_field('image'))){
          $image = get_sub_field('image');
          $img = \App\Controllers\App::imageWithAlt($image);
          $img_type = \App\Controllers\App::checkImgExtension($image['filename']);
          }
        ?>
        <?php if($rowCount++ % 2 == 1): ?>
          <div class="row mb-80">
            <div class="col-lg-5">
              <div class="img-wrap">
                <?php if(isset($img)): ?>
                  <?php if($img_type == "svg"): ?>
                    <?php
                      echo file_get_contents($img['image'])
                    ?>
                  <?php else: ?>
                    <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
                      srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>" />
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
            <div class="col-lg-7 pl-lg-5 mb-4 mb-lg-0">
              <div class="mb-4">
                <h2 class=""><?php echo $title; ?></h2>
                <h3 class="h5 bold-desc"><?php echo $subtitle; ?></h3>
              </div>
              <div class="text-gray body-link"><?php echo $body_copy; ?></div>
              <?php if(!empty($button['button_link'])): ?>
                <a href="<?php echo $button['button_link']; ?>" class="button-primary mt-32"><?php echo $button['button_text']; ?></a>
              <?php endif; ?>
            </div>
          </div>
        <?php else: ?>
          <div class="row mb-80">
            <div class="col-lg-7 pr-lg-5 order-2 order-lg-1 mb-4 mb-lg-0">
              <div class="mb-4">
                <h2 class=""><?php echo $title; ?></h2>
                <h3 class="h5 bold-desc"><?php echo $subtitle; ?></h3>
              </div>
              <div class="text-gray body-link"><?php echo $body_copy; ?></div>
              <?php if(!empty($button['button_link'])): ?>
                <a href="<?php echo $button['button_link']; ?>" class="button-primary mt-32"><?php echo $button['button_text']; ?></a>
              <?php endif; ?>
            </div>
            <div class="col-lg-5 order-1 order-lg-2">
              <div class="img-wrap ">
                <?php if(isset($img)): ?>
                  <?php if($img_type == "svg"): ?>
                    <?php
                      echo file_get_contents($img['image'])
                    ?>
                  <?php else: ?>
                    <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
                      srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>" />
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endif; ?>
      <?php endwhile; ?>
    <?php endif; ?>
  </div>
</section>
