
<?php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $title = get_field('title');

  $tweet_engine = new \App\Controllers\Twitter;

?>
<section data-<?php echo e($block['id']); ?> class="twitter-section">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
      </div>
      <div class="col-12">
        <div class="twitter-wrap">
          <?php
            $rowCount = 0;
            $row_zindex = count(get_field('tweets'));
          ?>
          <?php if(have_rows('tweets')): ?>
            <?php while(have_rows('tweets')): ?>
              <?php if($rowCount++ % 2 == 1): ?>
                <?php
                  the_row()
                ?>
                <div class="twitter-card twitter-right" style="z-index: <?php echo e($row_zindex); ?>">
                  <div class="t-box">
                    <?php echo get_sub_field('tweet'); ?>

                  </div>
                </div>
              <?php else: ?>
                <?php
                  the_row()
                ?>
                <div class="twitter-card twitter-left" style="z-index: <?php echo e($row_zindex); ?>">
                  <div class="t-box">
                    <?php echo get_sub_field('tweet'); ?>

                  </div>
                </div>
              <?php endif; ?>
              <?php
                  $row_zindex--;
              ?>
            <?php endwhile; ?>
            <div class="twitter-timeline"></div>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
