
<?php
  $title = get_field("title");
  $boxes = get_field("boxes");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

?>
<section data-<?php echo e($block['id']); ?> class="bg-light two-by-two">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <?php if( !empty( $title ) ): ?>
          <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        <?php endif; ?>
      </div>
      <?php $__currentLoopData = $boxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          if(!empty($box['icon'])){
          $icon = \App\Controllers\App::imageWithAlt($box['icon']);
          $icon_type = \App\Controllers\App::checkImgExtension($box['icon']['filename']);
          }
        ?>
        <div class="col-lg-6 mb-3 mb-lg-5 fade-in-animation">
          <?php if(isset($icon)): ?>
            <div class="box-wrap box-with-shadow box-icon-text ">
              <div class="d-flex align-items-center  mb-2 mb-lg-4">
                <?php if($icon_type == "svg"): ?>
                <span class="icon-montway mr-3 d-block d-lg-none ">
                  <?php
                    echo file_get_contents($icon['image'])
                  ?>
                </span>
              <?php else: ?>
                <img class="icon-montway" src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>"
                  srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>">
              <?php endif; ?>
                <h3 class=""><?php echo $box['title']; ?></h3>
              </div>
              <div class="d-flex">
                <?php if($icon_type == "svg"): ?>
                  <span class="icon-montway d-none d-lg-block mr-3 ">
                    <?php
                      echo file_get_contents($icon['image'])
                    ?>
                  </span>
                <?php else: ?>
                  <img class="icon-montway" src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>"
                    srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>">
                <?php endif; ?>
                <div class="body-link"><?php echo $box['body_copy']; ?></div>
              </div>
            </div>
          <?php else: ?>
            <div class="box-wrap box-with-shadow box-icon-text js-container-toggle">
              <div class="d-flex align-items-center justify-content-between mb-lg-4">
                <h2 class="h3"><?php echo $box['title']; ?></h2>
                <i class="icon icon-keyboard_arrow_right"></i>
              </div>
              <div class="text-wrap body-link"><?php echo $box['body_copy']; ?></div>
            </div>
          <?php endif; ?>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
