
<?php
  $display_reviews = get_field("single_rating");
  $padding = get_field("block_padding");
  // $title = get_field('title');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="bg-white ratings-slider position-relative">
  <div class="container">
    <div class="row justify-content-between">
      <div class="col-12 swiper-container ratings-swiper">
        <div class="swiper-wrapper">
          <?php $__currentLoopData = $display_reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="swiper-slide">
              <div class="rating-box">
                <?php
                  $stars = \App\Controllers\App::startRating($review['average_rating']);
                  $review_logo_type = \App\Controllers\App::checkImgExtension($review['company_logo']['filename']);
                  $review_logo = \App\Controllers\App::imageWithAlt($review['company_logo']);
                ?>
                <div>
                  <div class="logo mb-2">
                    <?php if($review_logo_type == "svg"): ?>
                      <?php
                        echo file_get_contents($review_logo['image'])
                      ?>
                    <?php else: ?>
                      <img src="<?php echo $review_logo['image']; ?>" alt="<?php echo $review_logo['alt']; ?>"
                        srcset="<?php echo $review_logo['small'] . $review_logo['medium'] . $review_logo['large']; ?>">
                    <?php endif; ?>
                  </div>
                  <div class="d-flex stars-wrap">
                    <?php for($i=0; $i<$stars['full']; $i++): ?>
                      <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                    <?php endfor; ?>
                    <?php if(isset($stars['half'])): ?>
                      <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-' .$stars['half'].'.png'; ?> />
                    <?php endif; ?>
                  </div>

                </div>
                <div class="d-flex align-items-center flex-md-column ">
                  <?php
                    $rating = number_format((float)$review['average_rating'], 1, '.', '');
                  ?>
                  <span class=" rating text-gray mr-3 mr-md-0"><?php echo $rating; ?></span>

                </div>
                <span class="d-block reviews-amount"><?php echo $review['number_of_ratings']; ?> reviews</span>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="swiper-pagination ratings-pagination"></div>

      </div>
      <div class="swiper-button-prev ratings-prev"></div>
      <div class="swiper-button-next ratings-next"></div>
    </div>
  </div>
</section>
