
<?php
  $title = get_field("title");
  $icon_star = get_field("five_stars_icon");
  $left_circle = get_field("left_circle");
  $right_circle = get_field("right_circle");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  if(!empty($icon_star)){
  $icon = \App\Controllers\App::imageWithAlt($icon_star);
  $icon_type = \App\Controllers\App::checkImgExtension($icon_star['filename']);
  }
?>
<section data-<?php echo e($block['id']); ?> class="bg-gray data-circles">
  <div class="container">
    <div class="row">
      <div class="col-12 mx-auto text-center mb-3">
        <h2 class="h5 mb-3 bold-desc"><?php echo $title; ?></h2>
        <?php if(!empty($icon)): ?>
        <?php if($icon_type == "svg"): ?>
          <?php
            echo file_get_contents($icon['image'])
          ?>
        <?php else: ?>
          <img src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>"
            srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>" />
        <?php endif; ?>
      <?php endif; ?>
      </div>
      <div class="col-lg-8 mx-auto text-center">
      <div class="circle-wrap d-flex flex-column align-items-center flex-md-row justify-content-center">
        <div class="circle mx-4 mb-3 mb-md-0" data-size="198" data-value="0.<?php echo $left_circle['percentage']; ?>" data-thickness="12">
          <div class="text">

            <span class="text-data-circle"><?php echo $left_circle['percentage']; ?>%</span>
            <p class="text-gray-medium"><?php echo $left_circle['title']; ?></p>
          </div>
        </div>
        <div class="circle mx-4"  data-size="198" data-value="0.<?php echo $right_circle['time']; ?>" data-thickness="12">
          <div class="text">
            <span class="text-data-circle"><?php echo $right_circle['time']; ?>s</span>
            <p class="text-gray-medium"><?php echo $right_circle['title']; ?></p>
          </div>
        </div>
      </div>
    </div>

    </div>
  </div>
</section>
