
<?php
$title = get_field("title");
$subtitle = get_field("subtitle");
$padding = get_field("block_padding");

$video_box = get_field("video");
$video_image_id = $video_box['overlay_image'];
if(!empty($video_image_id)){
	$video_image = \App\Controllers\App::imageWithAlt($video_image_id);
	$video_image_type = \App\Controllers\App::checkImgExtension($video_image_id['filename']);
}
$video_link = $video_box['video_link'];
$video_title = $video_box['overlay_title'];

$listing_box = get_field('listing_box');
$buttons = get_field("buttons");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="section-with-video" style="">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-3"><?php echo $title; ?></h2>
        <p class="mb-3 h5 font-weight-regular-bold"><?php echo $subtitle; ?></p>
      </div>

      <div class="col-lg-7 hover-box mb-32">
        <div class="video-wrap h-100 video-box-all">
          <div class="video-thumbnail position-relative">
            <p class="position-absolute video-title h2 text-center w-100 mob-hidden"><?php echo $video_title; ?> </p>
            <p class="position-absolute video-title h2 text-center w-100 play-btn-home"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="160" height="160" viewBox="0 0 160 160"><defs><circle id="a" cx="80" cy="80" r="80"/></defs><g fill="none" fill-rule="evenodd"><use fill="#232B36" fill-opacity=".2" xlink:href="#a"/><circle cx="80" cy="80" r="78" stroke="#FFF" stroke-width="4"/><path fill="#FFF" d="M119.636 77.837c1.858 1.195 1.853 3.134 0 4.326l-63.272 40.674c-1.858 1.195-3.364.365-3.364-1.835V38.998c0-2.208 1.51-3.027 3.364-1.835l63.272 40.674z"/></g></svg></p>

            <?php if(isset($video_image)): ?>
                <?php if($video_image_type == "svg"): ?>
                <?php
                  echo file_get_contents($video_image['image'])
                ?>
                  <?php else: ?>
                <img src="<?php echo $video_image['image']; ?>" alt="<?php echo $video_image['alt']; ?>" srcset="<?php echo $video_image['small'] . $video_image['medium'] . $video_image['large']; ?>">
                <?php endif; ?>
            <?php endif; ?>
          </div>
          <div class="video-link w-100 d-none h-100 align-items-center">
            <?php echo apply_filters( 'the_content', $video_link ); ?>
          </div>
        </div>
      </div>

      <div class="col-lg-5 py-lg-4 mb-32">
        <div class="video-box-wrap px-3 py-4 video-box-all">
          <h3 class="mb-4"><?php echo $listing_box['title']; ?></h3>
          <?php $__currentLoopData = $listing_box['steps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $steps): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="d-flex mb-5">
              <div class="vide-box-icon mr-3">
              <?php
              $img = \App\Controllers\App::checkImgExtension($steps['icon']['filename']);
              $icon = \App\Controllers\App::imageWithAlt($steps['icon']);
              ?>

              <?php if($img == "svg"): ?>
                <?php
                echo file_get_contents($icon['image'])
                  ?>
              <?php else: ?>
                <img src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>" srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>" />
              <?php endif; ?>
              </div>
              <div class="video-box-copy">
                <p class="h4 font-weight-bold video-box-title"><?php echo $steps['title']; ?></p>
                <p class="font-weight-bold"><?php echo $steps['body_copy']; ?></p>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
      <div class="col-lg-5 mx-auto px-lg-0">
        <div class="d-block d-lg-flex justify-content-between w-100">
          <a class="button-primary mb-4" href="<?php echo $buttons['get_a_quote']['button_link']; ?>"><?php echo $buttons['get_a_quote']['button_text']; ?></a>
          <a class="button-secondary mb-4" href="<?php echo $buttons['learn_more']['button_link']; ?>"><?php echo $buttons['learn_more']['button_text']; ?></a>
        </div>
      </div>
    </div>
  </div>
</section>
