
<?php
  $header_version = get_field("select_header_version");
  $title = get_field("title");
  $subtitle = get_field("subtitle");
  $button = get_field("button");
  $background_image_id = get_field("background_image");
  $padding = get_field("block_padding");
  $background_image_mobile_id = get_field('background_image_mobile');
  $button_type = get_field('button_type');
  if(!empty($background_image_id))
  {
  $background = \App\Controllers\App::imageWithAlt($background_image_id);
  }

  if(!empty($background_image_mobile_id))
  {
  $background_mobile = \App\Controllers\App::imageWithAlt($background_image_mobile_id);
  }

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $calculator_select = get_field('calculator_select');

?>
<?php if($header_version == "form"): ?>

  <section data-<?php echo e($block['id']); ?> class="hero-form position-relative no-lazy"
    style=" background: url(<?php echo $background['image']; ?>) bottom left no-repeat;" >
    <?php if(!empty($background_mobile['image'])): ?>
    <div class="bg-mobile d-md-none no-lazy"  style=" background-image: url(<?php echo $background_mobile['image']; ?>);">
      <div class="cover-overlay"></div>
      <img src="<?php echo $background_mobile['image']; ?>" class="d-none" loading="eager" role="presentation">
    </div>
    <div class="d-none">
      <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
    </div>
    <?php endif; ?>
    <div class="overlayer w-100 h-100 position-absolute"></div>
    <div class="container">
      <div class="row">
        <div class="col-lg-7 pt-3 fade-in-animation d-flex align-items-center ">
          <div class="pr-2">
            <h1 class="text-white"><?php echo $title; ?></h1>
            <h2 class="text-white h4"><?php echo $subtitle; ?></h2>
          </div>
        </div>

        <div class="col-lg-5 form-calculator">
        <?php if($calculator_select == 'mc_calculator'): ?>
          <?php echo do_shortcode('[mc_calculator]'); ?>
        <?php else: ?>
            <?php echo do_shortcode('[calculator]'); ?>
        <?php endif; ?>
        </div>

      </div>

      
  </div>

</section>

<?php endif; ?>

<?php if($header_version == "cta_header"): ?>
  <?php
      $form_hero = get_field('contact_form_shordcode');
      $form = GFAPI::get_form( $form_hero );
  ?>
  <?php if($form['title'] == 'Let\'s get Started'): ?>
  <div class="modal form-modal home-delivery-form" id="formModal-<?php echo e($form_hero); ?>" tabindex="-1" aria-labelledby="formModal-<?php echo e($form_hero); ?>" aria-hidden="true">
    <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body contact-form p-0">
          <div class="container-fluid">
            <div class="row">
              <div class="left-content cus-col-6">
                <div class="modal-text">
                  <h2 class="text-white">Find out how our Vehicle Home Delivery solution and Montway Business Portal can:</h2>
                  <ul class="bulleted-list mt-4">
                    <li class="text-white"><h3 class="text-white">expand your sales audience</h3></li>
                    <li class="text-white"><h3 class="text-white">engage motivated consumers</h3></li>
                    <li class="text-white"><h3 class="text-white">drive increased sales</h3></li>
                    <li class="text-white"><h3 class="text-white">simple and easy dealer website integration</h3></li>
                  </ul>
                </div>
                <div class="modal-logos d-flex justify-content-between align-items-center">
                  <img src="/app/uploads/2022/02/bbb-logo-transparent.png" alt="bbb-logo">
                  <img src="/app/uploads/2022/02/naaa_white_logo.png" alt="naaa" style="height: 60px;">
                  <img src="/app/uploads/2022/02/iara_white_logo.png" alt="iara">
                </div>
              </div>
              <div class="right-content cus-col-6">
                <?php gravity_form( $form_hero , true, true, false, null, true ); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php else: ?>
  <div class="modal form-modal" id="formModal-<?php echo e($form_hero); ?>" tabindex="-1" aria-labelledby="formModal-<?php echo e($form_hero); ?>" aria-hidden="true">
    <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body contact-form contact-form-btn">
          <?php gravity_form( $form_hero , true, false, false, null, true ); ?>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>

  <section data-<?php echo e($block['id']); ?> class="position-relative hero-bg no-lazy"
      style=" background-image: url(<?php echo $background['image']; ?>);" loading="eager">
      <?php if(!empty($background_mobile['image'])): ?>
      <div class="bg-mobile d-md-none no-lazy" style=" background-image: url(<?php echo $background_mobile['image']; ?>);" loading="eager"></div>
      <img src="<?php echo $background_mobile['image']; ?>" class="d-none" loading="eager" role="presentation">
      <?php endif; ?>
      <div class="d-none">
        <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
      </div>
      <div class="cover-overlay"></div>
      <div class="container">
        <div class="row">
          <div class="col-lg-7 fade-in-animation">
            <h1 class="text-white"><?php echo $title; ?></h1>
            <h2 class="text-white h4 mb-4"><?php echo $subtitle; ?></h2>
            <?php if($button_type == 'shortcode'): ?>
              <button class="button-primary" data-toggle="modal" data-target="#formModal-<?php echo e($form_hero); ?>"><?php echo $button['button_text']; ?></button>
            <?php else: ?>
                <a href="<?php echo $button['button_link']; ?>" class="button-primary"><?php echo $button['button_text']; ?></a>
            <?php endif; ?>
          </div>
        </div>
      </div>
  </section>
<?php endif; ?>

<?php if($header_version == "second_cta_header"): ?>
  <section data-<?php echo e($block['id']); ?>

    style=" background: url(<?php echo $background['image']; ?>) bottom center no-repeat;" class="position-relative second-cta-hero no-lazy" loading="eager">
    <?php if(!empty($background_mobile['image'])): ?>
    <div class="bg-mobile d-md-none no-lazy" style=" background-image: url(<?php echo $background_mobile['image']; ?>);" loading="eager"></div>
    <img src="<?php echo $background_mobile['image']; ?>" class="d-none" loading="eager" role="presentation">
    <?php endif; ?>
    <div class="d-none">
      <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
    </div>
    <div class="cover-overlay"></div>
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-7 fade-in-animation">
          <h1 class="text-white"><?php echo $title; ?></h1>
          <h2 class="text-white h4 mb-4"><?php echo $subtitle; ?></h2>
        </div>
        <div class="col-lg-4 offset-lg-1 text-center mt-5 mt-lg-0">

          <a href="<?php echo $button['button_link']; ?>" class="button-primary d-none d-lg-inline-block button-hero-cta"><?php echo $button['button_text']; ?></a>
          <a href="<?php echo $button['button_link']; ?>" class="button-primary d-block d-lg-none button-hero-cta"><?php echo $button['button_text_mobile']; ?></a>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>

<?php if($header_version == "non_cta_header"): ?>
  <section data-<?php echo e($block['id']); ?> class="position-relative non-cta-header no-lazy"
    style=" background: url(<?php echo $background['image']; ?>) center center no-repeat;" loading="eager">
    <?php if(!empty($background_mobile['image'])): ?>
    <div class="bg-mobile d-md-none no-lazy" style=" background-image: url(<?php echo $background_mobile['image']; ?>);" loading="eager"></div>
    <img src="<?php echo $background_mobile['image']; ?>" class="d-none" loading="eager" role="presentation">
    <?php endif; ?>
    <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
    <div class="cover-overlay"></div>
    <div class="container">
      <div class="row">
        <div class="col-12 col-md-10 col-lg-7 fade-in-animation">
          <h1 class="text-white"><?php echo $title; ?></h1>
          <h2 class="text-white h4"><?php echo $subtitle; ?></h2>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>

<?php if($header_version == "non_image_header"): ?>
  <section data-<?php echo e($block['id']); ?> class="position-relative no-lazy"
  style=" background: url(<?php echo $background['image']; ?>) bottom center no-repeat;" loading="eager">
  <?php if(!empty($background_mobile['image'])): ?>
  <div class="bg-mobile d-md-none no-lazy" style=" background-image: url(<?php echo $background_mobile['image']; ?>);" loading="eager">
    <img src="<?php echo $background_mobile['image']; ?>" class="d-none" loading="eager" role="presentation">
    <div class="cover-overlay"></div>
  </div>
  <?php endif; ?>
  <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
    <div class="container">
      <div class="row">
        <div class="col-lg-7 fade-in-animation">
          <h1 class="text-white mb-3"><?php echo $title; ?></h1>
          <h2 class="h4 text-white mb-4"><?php echo $subtitle; ?></h2>
          <a href="<?php echo $button['button_link']; ?>" class="button-transparent" target="_blank" rel="noopener"><?php echo $button['button_text']; ?></a>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>
