<?php $__env->startSection('content'); ?>
  <div class="container mt-5">
    <?php echo $__env->make('partials.page-header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <?php if(!have_posts()): ?>
      <div class="alert alert-warning">
        <?php echo e(__('Sorry, no results were found.', 'sage')); ?>

      </div>
      <?php echo get_search_form(false); ?>

    <?php endif; ?>

    <?php
      $page_id = get_queried_object_id();
      $cats = \App\Controllers\App::returnCategories();
      if(is_category()){
          $category_name = get_queried_object()->cat_name;
      }
      global $paged;
    ?>

    <h1 class="h2 mb-2"><?php echo ( is_category(  ) ) ? $category_name : get_the_title($page_id); ?></h1>
    <p class="mb-2 d-none d-lg-block">Select category</p>
    
    <div class="mb-5">
    <?php if( has_nav_menu('blog_category_navigation') ): ?>
      <?php echo wp_nav_menu(['theme_location' => 'blog_category_navigation', 'menu_class' => 'd-none d-lg-flex category-nav justify-content-between']); ?>

      <?php
          $navigation = wp_get_nav_menu_items( 'Blog Category Navigation' );
          // echo '<pre>';
          //   print_r($nav);
          //   echo '</pre>';
      ?>
      <select class="blog-navigation-select d-block d-lg-none">
        <option>Select category...</option>
        <?php $__currentLoopData = $navigation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($nav->url); ?>"><?php echo e($nav->title); ?></option>            
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    <?php endif; ?>
    </div>
    <div class="border-bottom mb-2 mb-lg-3"></div>

    <?php if( !is_category(  ) &&  $paged < 2): ?>
    <h2 class="mb-3 h4 font-weight-bold">Featured</h2>
      <?php
          $args = array(
            'post_type' => 'post',
            'posts_per_page' => 1,
            'tag' => 'featured'
          );
          $query = new WP_Query( $args );
      ?>
      <?php if( $query->have_posts() ): ?>
        <?php while( $query->have_posts() ): ?> <?php $query->the_post();
          $category = get_the_category();
          $cat_name = $category[0]->name;
          $cat_link = get_category_link($category[0]->term_id);
        ?>
        
        <div class="d-block d-md-flex featured-post overflow-hidden mb-56 mb-2">
          <div class="col-md-7 featured-image pr-2 mb-0 pl-0">
            <a href="<?php echo e(get_the_permalink()); ?>">
              <?php echo get_the_post_thumbnail(); ?>

            </a>
          </div>
          <div class="col-md-5 p-4 px-lg-4 pb-lg-3">
            <a href="<?php echo e($cat_link); ?>" class="featured-category mb-2 d-inline-block text-blue"><?php echo $cat_name; ?></a>
            <h2 class="featured-title h4 font-weight-bold mb-3"><a href="<?php echo e(get_the_permalink()); ?>"><?php echo get_the_title(); ?></a></h2>
            <p class="featured-date mb-3 text-gray-medium">Posted on <?php echo get_the_date(); ?></p>
            <p class="featured-excerpt mb-3"><?php echo wp_trim_words( get_the_content( null, false, get_the_ID() ), 50 ); ?></p>
            <div class="text-right"><a class="featured-link mt-4 d-inline-block text-blue" href="<?php echo get_the_permalink(); ?>"><span>Continue reading</span> <?php echo file_get_contents(home_url() . '/app/uploads/2021/12/arrow-right.svg'); ?></a></div>
          </div>
        </div>
        <?php endwhile; ?>   
      <?php endif; ?>
      <div class="border-bottom mb-3"></div>
    <?php endif; ?>
    <?php if( is_category() ): ?> 
    <div class="mb-3"><?php echo \App\Controllers\App::breadcrumb(); ?></div>
    <?php else: ?>
    <?php if( $paged < 2 ): ?>
    <h2 class="mb-3 h4 font-weight-bold ">Latest stories for you</h2>
    <?php endif; ?>
    <?php endif; ?>
    <div class="row mb-56 mb-2 <?php echo e(( $paged > 1 ) ? 'pt-2 pt-lg-4' : ''); ?>">
    <?php while(have_posts()): ?> <?php the_post() ?>
      <?php echo $__env->make('partials.content-'.get_post_type(), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endwhile; ?>
    </div>
    <?php
      global $wp_query;
    $big = 999999999;
    $max = intval( $wp_query->max_num_pages );
    $pagination = \App\Controllers\App::custom_pagination();
    // echo paginate_links( array(
    //         'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
    //         'format' => '?paged=%#%',
    //         'current' => max( 1, get_query_var('paged') ),
    //         'total' => $wp_query->max_num_pages,
    //         'prev_text' => __( '&laquo;' ),
    //         'next_text' => __( '&raquo;' ),
    // ) );
    echo $pagination;
    ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>