
<?php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $left_group = get_field('left_logo');
  $right_group = get_field('right_logo');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="logos-press">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4"><?php echo $title; ?></h2>
        <div class="text-gray body-link"><?php echo $body_copy; ?></div>
      </div>
      <div class="col-lg-7 mx-auto d-flex flex-column flex-sm-row justify-content-center mt-4">
        <div class="d-flex flex-column align-items-center justify-content-between pr-sm-4">
          <p class="p-4"><?php echo $left_group['title']; ?></p>
          <?php
            if(!empty($left_group['image'])){
            $img = \App\Controllers\App::imageWithAlt($left_group['image']);
            $img_type = \App\Controllers\App::checkImgExtension($left_group['image']['filename']);
            }
          ?>
          <div>

          <?php if(isset($img)): ?>
            <?php if($img_type == "svg"): ?>
              <?php
                echo file_get_contents($img['image'])
              ?>
            <?php else: ?>
              <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
                srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>" class="vertical-logo" />
            <?php endif; ?>
          <?php endif; ?>
        </div>

          <span class="mt-4"><?php echo $left_group['underline']; ?></span>
        </div>

        <div class="d-flex flex-column align-items-center justify-content-between pl-sm-5">
          <p class="p-4"><?php echo $right_group['title']; ?></p>
          <?php
            if(!empty($right_group['image'])){
            $img = \App\Controllers\App::imageWithAlt($right_group['image']);
            $img_type = \App\Controllers\App::checkImgExtension($right_group['image']['filename']);
            }
          ?>
          <?php if(isset($img)): ?>
          <div>

            <?php if($img_type == "svg"): ?>
            <?php
                echo file_get_contents($img['image'])
                ?>
            <?php else: ?>
            <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
            srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>" />
            <?php endif; ?>
          </div>
            <?php endif; ?>
          <span class="mt-4"><?php echo $right_group['underline']; ?></span>
        </div>
      </div>
    </div>
  </div>
</section>
