
<?php
$title = get_field("title");
$img = get_field("image");
$questions = get_field("questions");
if(!empty($img)){
	$image = \App\Controllers\App::imageWithAlt($img);
	$image_type = \App\Controllers\App::checkImgExtension($img['filename']);
}

$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;

?>
<section data-<?php echo e($block['id']); ?> class="bg-white faq-with-image">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <?php if( is_page('help-center') ): ?>
          <h1 class="mb-4 h2"><?php echo $title; ?></h1>  
        <?php else: ?>
          <h2 class="mb-4"><?php echo $title; ?></h2>
        <?php endif; ?>
        <div class="accordions-wrap mb-4 mb-lg-0">
          <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="accordion-item ">
              <h3 class="h5 my-1 js-accordion-trigger"><?php echo $question['question']; ?> <i
                  class="icon icon-keyboard_arrow_right"></i></h3>
              <div class="text-body body-link"><?php echo $question['answer']; ?></div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
      <div class="col-lg-5 offset-lg-1">
        <div class="img-wrap">
          <?php if(isset($image)): ?>
            <?php if($image_type == "svg"): ?>
              <?php
                echo file_get_contents($image['image'])
              ?>
            <?php else: ?>
              <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>

      </div>
      </div>

</section>
