<?php

namespace App\Controllers;

use PHPMailer\PHPMailer\Exception;

class Curl
{

    private $handler = null;
    private $url = '';
    public $info = [];
    private $data = [];
    private $method = 'get';
    public $content = '';

    public function url($url = '')
    {
        $this->url = $url;

        return $this;
    }

    public function data($data = [])
    {
        $this->data = $data;

        return $this;
    }

    public function method($method = 'get')
    {
        $this->method = $method;

        return $this;
    }

    public function send()
    {
        try {
            if ($this->handler == null) {
                $this->handler = curl_init();
            }
            switch (strtolower($this->method)) {
                case 'post':
                    curl_setopt_array($this->handler, [
                        CURLOPT_URL => $this->url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS =>
                            json_encode($this->data),
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type:  application/vnd.api+json'
                        ),
                        CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)'

                    ]);
                    break;
                default:
                    curl_setopt_array($this->handler, [
                        CURLOPT_URL => $this->url . '?' . http_build_query($this->data),
                        CURLOPT_RETURNTRANSFER => true,

                    ]);
            }

            $this->content = curl_exec($this->handler);
            $this->info = curl_getinfo($this->handler);
        } catch (Exception $e) {
            die($e->getMessage());
        }
    }

    public function close()
    {
        curl_close($this->handler);

        $this->handler = null;
    }
}
