<?php

namespace App;

/**
 * Theme customizer
 */
add_action('customize_register', function (\WP_Customize_Manager $wp_customize) {
    // Add postMessage support
    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->selective_refresh->add_partial('blogname', [
        'selector' => '.brand',
        'render_callback' => function () {
            bloginfo('name');
        }
    ]);

    $wp_customize->add_setting('upload_logo');

    $wp_customize->add_control(
      new \WP_Customize_Image_Control(
        $wp_customize,
        'upload_logo',
        array(
          'label' => 'Logo',
          'section' => 'title_tagline',
          'settings' => 'upload_logo',
          'transport' => 'postMessage',
        )
      )
    );

    $wp_customize->add_section(
        'aditional_scripts',
        array(
            'title' => 'Insert script in header or footer',
            'description' => 'Insert additional scripts in head or footer section of the web page( google analytics, chat...)',
            'priority' => 35,
        )
      );
      $wp_customize->add_setting(
        'head_script',
        array(
          'default' => '',
          //'sanitize_callback' => 'sanitize_text_field'
        )
      );
      $wp_customize->add_control(
        'head_script',
        array(
          'label' => 'Insert script befor closing head tag',
          'type' => 'textarea',
          'section' => 'aditional_scripts',
          'settings' => 'head_script',
          'transport' => 'postMessage'
        )
      );
      $wp_customize->add_setting(
        'open_body_script',
        array(
          'default' => '',
          //'sanitize_callback' => 'sanitize_text_field'
        )
      );
  
      $wp_customize->add_control(
        'open_body_script',
        array(
          'label' => 'Insert script after opening of body tag',
          'type' => 'textarea',
          'section' => 'aditional_scripts',
          'settings' => 'open_body_script',
          'transport' => 'postMessage'
        )
      );
      $wp_customize->add_setting(
        'close_body_script',
        array(
          'default' => '',
          //'sanitize_callback' => 'sanitize_text_field'
        )
      );
  
      $wp_customize->add_control(
        'close_body_script',
        array(
          'label' => 'Insert script before closing of body tag',
          'type' => 'textarea',
          'section' => 'aditional_scripts',
          'settings' => 'close_body_script',
          'transport' => 'postMessage'
        )
      );
      
      $wp_customize->add_setting(
        'footer_script',
        array(
          'default' => '',
          //'sanitize_callback' => 'sanitize_text_field'
        )
      );
  
      $wp_customize->add_control(
        'footer_script',
        array(
          'label' => 'Insert script in footer',
          'type' => 'textarea',
          'section' => 'aditional_scripts',
          'settings' => 'footer_script',
          'transport' => 'postMessage'
        )
      );
  
      // $wp_customize->add_setting(
      //   'youtube',
      //   array(
      //     'default' => '',
      //     'sanitize_callback' => 'sanitize_text_field'
      //   )
      // );
  
      // $wp_customize->add_control(
      //   'youtube',
      //   array(
      //     'label' => 'Youtube link',
      //     'section' => 'social_link',
      //     'settings' => 'youtube',
      //     'transport' => 'postMessage'
      //   )
      // );

      // $wp_customize->add_setting(
      //   'instagram',
      //   array(
      //     'default' => '',
      //     'sanitize_callback' => 'sanitize_text_field'
      //   )
      // );
  
      // $wp_customize->add_control(
      //   'instagram',
      //   array(
      //     'label' => 'Instagram link',
      //     'section' => 'social_link',
      //     'settings' => 'instagram',
      //     'transport' => 'postMessage'
      //   )
      // );
  
  
      $wp_customize->add_section(
        'footer',
        array(
            'title' => 'Footer',
            'priority' => 35,
        )
      );
      $wp_customize->add_setting( 'footer_logo' );
      $wp_customize->add_control(
        new \WP_Customize_Image_Control(
          $wp_customize,
          'footer_logo',
          array(
            'label' => 'Footer Logo',
            'section' => 'footer',
            'settings' => 'footer_logo',
            'transport' => 'postMessage',
          )
        )
      );
      $wp_customize->add_setting(
        'trucking_authority_data',
        array(
          'default' => '',
        //   'sanitize_callback' => 'sanitize_text_field'
        )
      );
  
      $wp_customize->add_control(
        'trucking_authority',
        array(
          'label' => 'Trucking Authority Data',
          'type' => 'textarea',
          'section' => 'footer',
          'settings' => 'trucking_authority_data',
          'transport' => 'postMessage'
        )
      );

      $wp_customize->add_setting( 'trucking_authority_data_image' );
      $wp_customize->add_control(
        new \WP_Customize_Image_Control(
          $wp_customize,
          'trucking_authority_data_image',
          array(
            'label' => 'Trucking Authority Data Image',
            'section' => 'footer',
            'settings' => 'trucking_authority_data_image',
            'transport' => 'postMessage',
          )
        )
      );

      $wp_customize->add_setting(
        'manifesto',
        array(
          'default' => '',
        //   'sanitize_callback' => 'sanitize_text_field'
        )
      );
  
      $wp_customize->add_control(
        'company_data',
        array(
          'label' => 'Company Data',
          'type' => 'textarea',
          'section' => 'footer',
          'settings' => 'manifesto',
          'transport' => 'postMessage'
        )
      );
});

/**
 * Customizer JS
 */
add_action('customize_preview_init', function () {
    wp_enqueue_script('sage/customizer.js', asset_path('scripts/customizer.js'), ['customize-preview'], null, true);
});
