"use strict";

(function () {
	var __modules = {},
	    __modulesCache = {},
	    __moduleIsCached = {};

	function __require(uid, parentUid) {
		if (!__moduleIsCached[uid]) {
			__modulesCache[uid] = { "exports": {}, "loaded": false };
			__moduleIsCached[uid] = true;
			if (uid === 0 && typeof require === "function") {
				require.main = __modulesCache[0];
			} else {
				__modulesCache[uid].parent = __modulesCache[parentUid];
			}

			__modules[uid].call(this, __modulesCache[uid], __modulesCache[uid].exports);
			__modulesCache[uid].loaded = true;
		}
		return __modulesCache[uid].exports;
	}

	function __getFilename(path) {
		return require("path").resolve(__dirname + "/" + path);
	}

	function __getDirname(path) {
		return require("path").resolve(__dirname + "/" + path + "/../");
	}

	__modules[0] = function (module, exports) {
		const glob = require('glob');
		const chokidar = require('chokidar');

		const WebpackFile = __require(1, 0);

		var _require = __require(2, 0);

		const promisify = _require.promisify;


		const errorMsg = msg => `\u001B[31m${msg}\u001B[0m`;

		const GLOB_CWD_AUTO = null;

		const globAsync = promisify(glob);

		class PatternUndefinedError extends Error {
			constructor() {
				super(errorMsg('[copy-globs] You must provide glob pattern.'));
				this.name = 'PatternUndefinedError';
			}
		}

		class ArgsArrayError extends TypeError {
			constructor() {
				super(errorMsg('[copy-globs] pattern cannot be an array.\n' + 'For multiple folders, use something like:\n\n' + '  +(images|fonts)/**/*\n\n' + 'See also: https://github.com/isaacs/node-glob#glob-primer\n'));
				this.name = 'ArgsArrayError';
			}
		}

		const validatePattern = pattern => {
			if (pattern === undefined) {
				throw new PatternUndefinedError();
			}
			if (Array.isArray(pattern)) {
				throw new ArgsArrayError();
			}
		};

		const normalizeArguments = input => {
			validatePattern(input);
			const options = {};
			if (typeof input === 'string') {
				options.pattern = input;
			} else {
				validatePattern(input.pattern);
				return input;
			}
			return options;
		};

		module.exports = class {
			constructor(o) {
				const options = normalizeArguments(o);
				this.pattern = options.pattern;
				this.disable = options.disable;
				this.output = options.output || '[path][name].[ext]';
				this.globOptions = Object.assign(options.globOptions || {}, { cwd: GLOB_CWD_AUTO });
				this.globOptions.nodir = true;
				this.manifest = options.manifest || {};
				this.files = [];
				this.watcher = null;
			}
			apply(compiler) {
				if (this.disable) {
					return;
				}
				this.compiler = compiler;
				this.resolveWorkingDirectory();
				compiler.plugin('emit', this.emitHandler.bind(this));
				compiler.plugin('after-emit', this.afterEmitHandler.bind(this));
				compiler.plugin('watch-run', this.watcherHandler.bind(this));
			}
			watcherHandler(compilation, callback) {
				if (!this.watcher) {
					this.startWatcher();
				}
				callback();
			}
			startWatcher() {
				this.watcher = chokidar.watch(this.pattern, { ignoreInitial: true, cwd: this.globOptions.cwd }).on('add', () => this.compiler.run(() => {})).on('change', () => this.compiler.run(() => {})).on('unlink', () => this.compiler.run(() => {}));
			}
			emitHandler(compilation, callback) {
				this.compilation = compilation;
				globAsync(this.pattern, this.globOptions).then(paths => Promise.all(paths.map(this.processAsset.bind(this))), err => compilation.errors.push(err)).then(() => {
					Object.keys(this.files).forEach(absoluteFrom => {
						const file = this.files[absoluteFrom];
						this.manifest[file.relativeFrom] = file.webpackTo;
						this.compilation.assets[file.webpackTo] = {
							size: () => file.stat.size,
							source: () => file.content
						};
					});
				}).then(callback);
			}
			afterEmitHandler(compilation, callback) {
				Object.keys(this.files).filter(absoluteFrom => !compilation.fileDependencies.includes(absoluteFrom)).forEach(absoluteFrom => compilation.fileDependencies.push(absoluteFrom));
				callback();
			}
			resolveWorkingDirectory() {
				if (this.globOptions.cwd === GLOB_CWD_AUTO) {
					this.globOptions.cwd = this.compiler.options.context;
				}
				this.context = this.globOptions.cwd || this.compiler.options.context;
			}
			processAsset(relativeFrom) {
				if (this.compilation.assets[relativeFrom]) {
					return Promise.resolve();
				}
				return this.addAsset(new WebpackFile(relativeFrom, this.output, this.context));
			}
			addAsset(file) {
				const asset = this.getAsset(file.absoluteFrom);
				if (asset && asset.hash === file.hash) {
					return null;
				}
				this.files[file.absoluteFrom] = file;
				return file;
			}
			getAsset(absoluteFrom) {
				return this.files[absoluteFrom];
			}
		};

		return module.exports;
	};

	__modules[1] = function (module, exports) {
		const fs = require('fs');
		const path = require('path');
		const utils = require('loader-utils');
		const Cache = __require(3, 1);

		var _require2 = __require(2, 1);

		const fixPath = _require2.fixPath,
		      interpolateName = _require2.interpolateName;


		const destructive = ['relativeFrom', 'output', 'context'];
		const memoized = ['absoluteFrom', 'stat', 'content', 'webpackTo', 'hash'];
		const enumerable = destructive.concat(memoized);

		const data = new WeakMap();

		class WebpackFile {
			constructor(relativeFrom, output = '[path][name].[ext]', context = process.cwd()) {
				this.data = new Cache();
				this.relativeFrom = relativeFrom;
				this.context = context;
				this.output = output;
			}
			get data() {
				return data.get(this);
			}
			set data(cache) {
				if (cache instanceof Cache) {
					data.set(this, cache);
				}
			}
			reset() {
				this.data.forEach(prop => {
					if (!this.destructive.includes(prop)) {
						this.data.delete(prop);
					}
				});
			}
		}

		Object.defineProperty(WebpackFile.prototype, 'dataMap', {
			enumerable: false,
			get() {
				return {
					absoluteFrom() {
						return path.resolve(this.context, this.relativeFrom);
					},
					stat() {
						return fs.statSync(this.absoluteFrom);
					},
					content() {
						return fs.readFileSync(this.absoluteFrom);
					},
					webpackTo() {
						return fixPath(interpolateName(this.output, this.relativeFrom, this.content));
					},
					hash() {
						return utils.getHashDigest(this.content);
					}
				};
			}
		});

		Object.defineProperty(WebpackFile.prototype, 'destructive', {
			enumerable: false,
			value: destructive,
			writable: true
		});

		enumerable.forEach(property => Object.defineProperty(WebpackFile.prototype, property, {
			enumerable: true,
			set(value) {
				this.data.set(property, value);
				if (this.destructive.includes(property)) {
					this.reset();
				}
			},
			get() {
				if (this.dataMap[property] === undefined) {
					return this.data.get(property);
				}
				return this.data.get(property, this.dataMap[property].bind(this));
			}
		}));

		module.exports = WebpackFile;

		return module.exports;
	};

	__modules[2] = function (module, exports) {
		const fixPath = __require(4, 2);
		const interpolateName = __require(5, 2);
		const memoize = __require(6, 2);
		const promisify = __require(7, 2);

		module.exports = { fixPath, interpolateName, memoize, promisify };

		return module.exports;
	};

	__modules[3] = function (module, exports) {
		var _require3 = __require(2, 3);

		const memoize = _require3.memoize;


		module.exports = class Cache extends Map {
			constructor() {
				const self = new Map();
				self.__proto__ = Cache.prototype;
				return self;
			}
			get(key, fn = null, ...args) {
				if (this.has(key) || !fn) {
					return Map.prototype.get.call(this, key);
				}
				this.set(key, memoize(fn, ...args));
				return Map.prototype.get.call(this, key);
			}
		};

		return module.exports;
	};

	__modules[4] = function (module, exports) {
		module.exports = a => a.replace(/\\/g, '/');

		return module.exports;
	};

	__modules[5] = function (module, exports) {
		const path = require('path');
		const utils = require('loader-utils');

		module.exports = (pattern, relativeFrom, content) => {
			let webpackTo = pattern;
			let resourcePath = relativeFrom;

			const basename = path.basename(resourcePath);
			let dotRemoved = false;
			if (basename[0] === '.') {
				dotRemoved = true;
				resourcePath = path.join(path.dirname(resourcePath), basename.slice(1));
			}

			if (!path.extname(resourcePath)) {
				webpackTo = webpackTo.replace(/\.?\[ext]/g, '');
			}

			if (resourcePath.indexOf('/') < 0) {
				resourcePath = `/${resourcePath}`;
			}

			webpackTo = utils.interpolateName({ resourcePath }, webpackTo, { content });

			if (dotRemoved) {
				webpackTo = path.join(path.dirname(webpackTo), `.${path.basename(webpackTo)}`);
			}
			return webpackTo;
		};

		return module.exports;
	};

	__modules[6] = function (module, exports) {
		let cache = new WeakMap();

		module.exports = function memoize(fn, ...args) {
			if (!cache.has(fn)) cache.set(fn, fn.apply(fn, args));
			return cache.get(fn);
		};

		module.exports.expire = (fn, ...args) => {
			cache.delete(fn, fn.apply(fn, args));
		};

		module.exports.clear = () => {
			cache = new WeakMap();
		};

		return module.exports;
	};

	__modules[7] = function (module, exports) {
		module.exports = (callback, thisArg) => function () {
			const args = [].slice.call(arguments);
			return new Promise((resolve, reject) => {
				args.push((err, data) => err === null ? resolve(data) : reject(err));
				return callback.apply(thisArg, args);
			});
		};

		return module.exports;
	};

	if (typeof module === "object") module.exports = __require(0);else return __require(0);
})();