'use strict';

/** @typedef {import('stylelint').RangeType} RangeType */
/** @typedef {import('stylelint').StylelintDisableOptionsReport} StylelintDisableOptionsReport */

/**
 * @param {import('stylelint').StylelintResult[]} results
 * @returns {StylelintDisableOptionsReport}
 */
module.exports = function (results) {
	/** @type {StylelintDisableOptionsReport} */
	const report = [];

	results.forEach((result) => {
		// File with `CssSyntaxError` have not `_postcssResult`
		if (!result._postcssResult) {
			return;
		}

		if (!result._postcssResult.stylelint.config) {
			// Linting error
			return;
		}

		const configRules = result._postcssResult.stylelint.config.rules || {};

		const usedRules = new Set(Object.keys(configRules));

		usedRules.add('all');

		/** @type {import('stylelint').StylelintDisableReportEntry} */
		const sourceReport = { source: result.source, ranges: [] };
		const rangeData = result._postcssResult.stylelint.disabledRanges;
		const disabledRules = Object.keys(rangeData);

		disabledRules.forEach((rule) => {
			if (usedRules.has(rule)) {
				return;
			}

			rangeData[rule].forEach((range) => {
				if (!range.strictStart && !range.strictEnd) {
					return;
				}

				sourceReport.ranges.push({
					rule,
					start: range.start,
					end: range.end,
					unusedRule: rule,
				});
			});
		});

		if (sourceReport.ranges.length > 0) {
			report.push(sourceReport);
		}
	});

	return report;
};
