<?php
namespace HWID\ACFGravity;

class ACF_GF_DropDown {

	public static function init() {

		add_filter( 'acf/load_field/name=contact_form_shordcode', [ 'HWID\ACFGravity\ACF_GF_DropDown', 'populate_gform_dropdown' ] );
    
	}

	/**
	 * Populate an ACF drop down field with the current active Gravity Forms
	 *
	 * @param array $field
	 *
	 * @return array
	 */
	static function populate_gform_dropdown( $field ) {

		// if GFAPI doesn't exist, GravityForms is not running so bail early
		if ( ! class_exists( 'GFAPI' ) ) {
			return $field;
		}

		$forms = \GFAPI::get_forms();

		// Set the initial 'Select a Form' drop down value
		$choices = [
			'' => __( 'Select a Form', 'textdomain' ),
		];

		// Add each form to an arrach with the form ID as the array key
		foreach( $forms as $form ) {
			$choices[$form['id']] = $form['title'];
		}

		$field['choices'] = $choices;

		return $field;
	}
}
ACF_GF_DropDown::init();