/* eslint-disable quotes */
/* eslint-disable no-unused-vars */
import moment from "moment";
import Inputmask from "inputmask";
import datepickerFactory from 'jquery-datepicker';
import $ from "jquery";
datepickerFactory($);
import { Swiper, Navigation, Pagination, Autoplay } from "swiper";
Swiper.use([Navigation, Pagination, Autoplay]);

// document.querySelector('#email_address').addEventListener('focusout', function(){
//      // eslint-disable-next-line no-undef
//     console.log(object_name.emailVal);
// })


const counterAnim = (qSelector, start = 0, end, duration = 1000) => {
    const target = qSelector;
    let startTimestamp = null;
    const step = (timestamp) => {
        if (!startTimestamp) {
            startTimestamp = timestamp;
        }
        const progress = Math.min((timestamp - startTimestamp) / duration, 1);
        target.innerText = Math.floor(
            progress * (end - start) + start
        ).toLocaleString('en-US');
    if (progress < 1) {
        window.requestAnimationFrame(step);
    }
    };
    window.requestAnimationFrame(step);
};
//#endregion - end of - number counter animation
const counterCheck = document.querySelector('.counter-wrap-select');
const counterTriggerElement = document.querySelector('.counter-trigger');
function counter()
{
    const counter = document.querySelectorAll('.counter');
    counter.forEach(function (element) {
        const data = element.dataset.countend;
        counterAnim(element, 1, data, 1000);
    });
}
let counterFlag = true;
function counterTrigger()
{
    if (isOnScreen(counterTriggerElement) && counterFlag == true) {
        counter();
        counterFlag = false;
    }
}
if (counterCheck) {
    counterTrigger();
    window.addEventListener('scroll', function () {
        counterTrigger();
    });
}

function isOnScreen(elem, viewPort = '')
{
    // if the element doesn't exist, abort
    if (elem.length == 0) {
        return;
    }
    var rect = elem.getBoundingClientRect();
    var elemTop = rect.top;
    var elemBottom = rect.bottom;
    var isVisible;

    // Only completely visible elements return true:
    if (viewPort == 'all') {
        isVisible = (elemTop >= 0) && (elemBottom <= window.innerHeight);
    } else {
        // Partially visible elements return true:
        isVisible = elemTop < window.innerHeight && elemBottom >= 0;
    }
    return isVisible;
}
//logos slider
let logosSlider = new Swiper('.logos-swiper', {
    slidesPerGroup: 1,
    loop: false,
    slidesPerView: 5,
    spaceBetween: 20,
    pagination: {
        el: '.swiper-pagination.logos-pagination',
        clickable: true,
    },
    navigation: {
        nextEl: '.logos-next',
        prevEl: '.logos-prev',
    },
    breakpoints: {
        768: {
            spaceBetween: 20,
            slidesPerGroup: 1,
            slidesPerView: 2,
        },
        991: {
            slidesPerGroup: 5,
            slidesPerView: 5,
            spaceBetween: 20,
            pagination: false,
        },
    },
});

//images slider with table section
let tableSlider = new Swiper(".table-swiper", {
    loop: true,
    slidesPerView: 1,
    spaceBetween: 15,
    autoplay: {
        delay: 4000,
    },
    pagination: {
        el: ".swiper-pagination.table-pagination",
        clickable: true,
    },
    navigation: {
        nextEl: ".table-next",
        prevEl: ".table-prev",
    },
});

//blue table swiper
let blueTableSwiper = new Swiper('.blue-table-swiper', {
    loop: true,
    slidesPerView: 1,
    spaceBetween: 15,
    autoplay: {
        delay: 4000,
    },
    pagination: {
        el: ".blue-table-pagination",
    },
    navigation: {
        nextEl: ".blue-table-next",
        prevEl: ".blue-tabel-prev",
    },
    breakpoints: {
        768: {
            loop: true,
            slidesPerView: 3,
            spaceBetween: 0,
        },
    },
})

//reviews slider
let reviewsSliderThreeCards = new Swiper(".reviews-swiper-three-cards", {
    slidesPerGroup: 1,
    loop: false,
    slidesPerView: 1,
    spaceBetween: 20,
    pagination: {
        el: ".swiper-pagination.reviews-pagination",
        dynamicBullets: true,
    },
    navigation: {
        nextEl: ".review-next",
        prevEl: ".review-prev",
    },
    breakpoints: {
        768: {
            spaceBetween: 20,
            slidesPerGroup: 1,
            slidesPerView: 2,
        },
        991: {
            slidesPerGroup: 3,
            slidesPerView: 3,
            spaceBetween: 20,
            pagination: false,
        },
    },
});

//reviews slider
let reviewsSlider = new Swiper(".reviews-swiper", {
    slidesPerGroup: 1,
    loop: false,
    slidesPerView: 1,
    spaceBetween: 20,
    pagination: {
        el: ".swiper-pagination.reviews-pagination",
        dynamicBullets: true,
    },
    navigation: {
        nextEl: ".review-next",
        prevEl: ".review-prev",
    },
    breakpoints: {
        768: {
            spaceBetween: 20,
            slidesPerGroup: 1,
            slidesPerView: 2,
        },
        991: {
            slidesPerGroup: 2,
            slidesPerView: 2,
            spaceBetween: 20,
            pagination: false,
        },
    },
});

//ratings slider
let ratingsSlider = new Swiper(".ratings-swiper", {
    slidesPerGroup: 1,
    loop: false,
    slidesPerView: 1,
    spaceBetween: 20,
    pagination: {
        el: ".swiper-pagination.ratings-pagination",
        clickable: true,
    },
    navigation: {
        nextEl: ".ratings-next",
        prevEl: ".ratings-prev",
    },
    breakpoints: {
        768: {
            spaceBetween: 20,
            slidesPerGroup: 1,
            slidesPerView: 2,
        },
        991: {
            slidesPerGroup: 3,
            slidesPerView: 3,
            spaceBetween: 21,
            pagination: false,
        },
    },
});

//footer phone number
const footerCopy = document.querySelector("footer .copy");
if (footerCopy && footerCopy.querySelector("a")) {
    footerCopy.querySelector("a").classList.add("is-underline");
}

//post banner animation
const banner = document.querySelector('.post-baner');
const bottomBanner = document.querySelector('.post-baner-bottom');
var top = window.scrollY;
var height = document.body.getBoundingClientRect().height - window.innerHeight;
let bannerFlag = true;
function tada_banner()
{
    if (isOnScreen(banner, 'all') && bannerFlag == true) {
        banner.classList.add('tada', 'fade-element')
        bannerFlag == false;
    }
}

function bounceInLeft(num1, num2)
{
    var percent = Math.ceil(num1 / num2 * 100);
    if (percent > 10) {
        bottomBanner.classList.add('bounceInLeft');
    }
}
if (banner) {
    bounceInLeft(top, height);
    tada_banner();
    window.addEventListener('scroll', function () {
        tada_banner();
        bounceInLeft(top, height);
    });
}

const progressBar = document.querySelector('#progress');
//post progres bar
function updateProgress(num1, num2)
{
    var percent = Math.ceil(num1 / num2 * 100) + '%';
    progressBar.style.width = percent;
}
if (progressBar) {
    updateProgress(top, height);
    window.addEventListener('scroll', function () {
        top = window.scrollY;
        height = document.body.getBoundingClientRect().height - window.innerHeight;
        updateProgress(top, height);
    });
}

// form button
const submitButton = document.querySelectorAll('.contact-form-btn .gform_footer');
submitButton.forEach(function (e) {
    const formCloseButton = document.createElement('button');
    formCloseButton.textContent = 'Cancle';
    formCloseButton.classList.add('form-close-btn', 'green-button-white-bac');
    formCloseButton.setAttribute('data-dismiss', 'modal');
    e.prepend(formCloseButton);
})
const formModal = document.querySelectorAll('.form-modal');
if (formModal) {
    var usedIds = {};

    for (let i = 0; i < formModal.length; i++) {
        const id = formModal[i].getAttribute("id");
        if (usedIds[id]) {
            formModal[i].parentNode.removeChild(formModal[i]);
        } else {
            usedIds[id] = true;
        }
    }
}

//smooth scroll
const links = document.querySelectorAll(".tabs-wrap .tab-link");
links.forEach(function (link) {
    link.addEventListener("click", clickHandler);
})

function clickHandler(e)
{
    e.preventDefault();
    const href = this.getAttribute("href");
    const offsetTop = document.querySelector(href).offsetTop - 100;

    scroll({
        top: offsetTop,
        behavior: "smooth",
    });
}

//HAWAII MAP
const closeButtonsMap = document.querySelectorAll(
    ".hawaii-map .button-close"
);
const mapInfoBoxes = document.querySelectorAll(".hawaii-map .port-box");
const detailedInfoBoxes = document.querySelectorAll(
    ".hawaii-map .port-detailed"
);

mapInfoBoxes &&
    mapInfoBoxes.forEach((box, i) => {
        box.addEventListener("click", (e) => openDetailedInfo(box, i, e));
    });

function openDetailedInfo(box, i, e)
{
    if (window.innerWidth > 991) {
        mapInfoBoxes.forEach((el) => el.classList.remove("is-open"));
        detailedInfoBoxes.forEach(
            (el) =>
            el.classList.remove("slit-in-vertical")
        );
        detailedInfoBoxes.forEach(
            (el) =>
            el.classList.add("swing-out-top-bck")
        );
        if (e.currentTarget === box) {
            box.classList.add("is-open");
        }
        if (!box.classList.contains("is-open")) {
            detailedInfoBoxes[i].classList.remove("slit-in-vertical");
            detailedInfoBoxes[i].classList.add("swing-out-top-bck");
        }
        if (box.classList.contains("is-open")) {
            detailedInfoBoxes[i].classList.add("slit-in-vertical");
            detailedInfoBoxes[i].classList.remove("swing-out-top-bck");
        }
    }
}

closeButtonsMap &&
    closeButtonsMap.forEach(
        (button, index) =>
        button.addEventListener("click", () => closeDetailedInfo(index))
    );

function closeDetailedInfo(i)
{
    detailedInfoBoxes[i].classList.add("swing-out-top-bck");
    mapInfoBoxes[i].classList.remove("is-open");
}

//TABS - HAWAII PAGE
const tabContainers = Array.from(
    document.querySelectorAll(".tab-container")
);

function animateSteps(stepsArray)
{
    stepsArray.forEach((step) => {
        if (step.classList.contains("fade-in-animation")) {
            step.classList.toggle("fade-in-animation");
        }
        step.classList.toggle("fade-in-animation");
    });
}

tabContainers.forEach((container) => {
    const tabButtons = Array.from(container.querySelectorAll(".tab-button"));
    const tabContent = Array.from(
        container.querySelectorAll(".steps-hawaii")
    );
    const stepsHawaii = Array.from(
        container.querySelectorAll(".steps-hawaii .single-step")
    );

    tabButtons && tabButtons.forEach(
        (tab) =>
        tab.addEventListener("click", (event) => {
            if (event.currentTarget.classList.contains("is-active")) {
                return;
            }
                tabContent.forEach((content) => {
                    if (content.classList.contains(tab.id)) {
                        content.classList.toggle("is-hidden");
                    } else {
                        if (!content.classList.contains("is-hidden")) {
                            content.classList.add("is-hidden");
                        }
                    }
                });
                animateSteps(stepsHawaii);
                tabButtons.forEach((el) => {
                    if (el.classList.contains("is-active")) {
                        el.classList.toggle("is-active");
                    }
                });
                event.currentTarget.classList.toggle("is-active");
            })
    );
});

//REVIEWS PAGE - SHOW MORE BUTTON
const loadReviewsButton = document.querySelector(".show-reviews-button");
const hiddenReviews = document.querySelectorAll(
    ".reviews-grid .row.d-none, .post-col.d-none"
);

loadReviewsButton &&
    loadReviewsButton.addEventListener("click", function (params) {
        loadReviewsButton.classList.add("d-none");
        hiddenReviews.forEach((row) => row.classList.remove("d-none"));
    });

//ACCORDIONS
function findAncestor(el, cls)
{
    let parent = el;
    while (!parent.classList.contains(cls)) {
        parent = parent.parentNode;
    }
    return parent;
}

const accordionTrigger = Array.from(
    document.querySelectorAll(".js-accordion-trigger")
);
const homeSecondAccordion = document.querySelector(
    ".home .accordions-wrap div:nth-of-type(2)"
);
const accordion = document.querySelector(".accordions-wrap");
const graphList = document.querySelector(".list-graph .list-wrap");
const textImageList = document.querySelector(".text-image-list .text-img-list-wrap");
if (accordion) {
    var accordionWrap = document.querySelector(".accordions-wrap");
    if (!accordionWrap.classList.contains('no-open')) {
        document
            .querySelector(".accordions-wrap div:first-child")
            .classList.add("is-open");
        homeSecondAccordion && homeSecondAccordion.classList.add("is-open");
    }
}

if (graphList) {
    document
        .querySelector(".list-graph .list-wrap div:first-child")
        .classList.add("is-open");
}

if (textImageList) {
    document
        .querySelector(".text-image-list .text-img-list-wrap div:first-child")
        .classList.add("is-open");
}

function toggleAccordion(e)
{
    e.preventDefault();
    const trigger = e.currentTarget;
    const accordion = findAncestor(trigger, "accordions-wrap");
    const el = findAncestor(trigger, "accordion-item");

    if (el.classList.contains("is-open")) {
        return;
    }

    const openItems = accordion.querySelectorAll(".is-open");
    if (openItems) {
        openItems.forEach((el) => el.classList.remove("is-open"));
    }
    el.classList.toggle("is-open");
}

accordionTrigger.forEach(
    (el) =>
    el.addEventListener("click", toggleAccordion)
);

const containerIconText = Array.from(
    document.querySelectorAll(".js-container-toggle")
);

function toggleIconText(e)
{
    const target = e.currentTarget;
    target.classList.toggle("is-open");
}

containerIconText.forEach(
    (el) =>
    el.addEventListener("click", toggleIconText)
);

const buttonTrigger = Array.from(
    document.querySelectorAll(".js-button-trigger")
);

function toggleContainer(e)
{
    const trigger = e.currentTarget;
    const triggerText = trigger.querySelector(".js-button-text");
    const containerParent = findAncestor(trigger, "js-parent-container-open");
    const itemsHidden = Array.from(
        containerParent.querySelectorAll(".item-hidden")
    );

    itemsHidden.forEach((itemHidden) => {
        itemHidden.classList.toggle("is-open");
    });

    containerParent.classList.toggle("show-hidden-items");

    if (trigger.className.includes("js-see-more-button")) {
        const { textOpen } = trigger.dataset;
        const { textClose } = trigger.dataset;

        if (triggerText && containerParent) {
            triggerText.innerHTML = containerParent.className.includes(
                "show-hidden-items"
            )
                ? textOpen
                : textClose;
        }
    }
}

buttonTrigger && buttonTrigger.forEach(
    (el) =>
    el.addEventListener("click", toggleContainer)
);

//video sektion load of video
const playBtn = document.querySelector(".play-btn-home");
const videoImage = document.querySelector(".video-thumbnail");
const videoIframe = document.querySelector(".video-link");
const videoBox = document.querySelectorAll(".video-box-all");
const iframe = document.querySelector(".video-link iframe");
playBtn &&
    playBtn.addEventListener("click", function () {
        iframe.src += "&autoplay=1";
        setTimeout(function () {
            videoImage.classList.add("d-none");
            videoIframe.classList.remove("d-none");
        }, 400);
        videoBox.forEach(function (element) {
            element.classList.add("transform-0");
        });
    });

//tabel tabs
const tabs = document.querySelectorAll(".table-button");
const tables = document.querySelectorAll(".table-wrap");
function clickTabs()
{
    tabs.forEach(function (el) {
        el.classList.remove("active");
    });
    this.classList.add("active");
    var activeTab = this.id;
    tables.forEach(function (e) {
        var dataTable = e.getAttribute("data-tab");
        console.log(dataTable + " " + activeTab);
        e.classList.add("d-none");
        e.classList.remove("fade-in-animation");
        if (dataTable == activeTab) {
            e.classList.remove("d-none");
            e.classList.add("fade-in-animation");
        }
    });
}
tabs.forEach(function (e) {
    e.addEventListener("click", clickTabs);
});

var timer;
var timeout = 1000;
$('#search_post').on('input', function () {
    clearTimeout(timer);
    var search = $('#search_post');
    timer = setTimeout(function () {
        $.ajax({
            url: search.attr('action'),
            data: search.serialize(), // form data
            type: search.attr('method'), // POST
            beforeSend: function (xhr) {
                console.log(xhr);
            },
            success: function (data) {
                if (data.length > 0) {
                    $('#questions').html(data);
                    $('#questions').slideDown();
                } else {
                    $('#questions').slideUp();
                }
            },
        });
        return false;
    }, timeout);

});
$('#search_post').on('focusin', function () {
    $('#questions').slideDown();
})
$('#search_post').on('focusout', function () {
    $('#questions').slideUp();
})
//category navigation
const catNavigation = document.querySelector(".blog-navigation-select");
if (catNavigation) {
    catNavigation.addEventListener('change', function () {
        window.location = this.value;
    });
}


//calculator
const motorCalculator = document.querySelector("#mc_calculator_form");
const buttonStepOne = document.querySelector(".calculator-container .button-step-1");
const buttonStepTwo = document.querySelector(".calculator-container .button-step-2");
const buttonStepThree = document.querySelector(".calculator-container .button-step-3");

const fieldsetOne = document.querySelector(".calculator-container fieldset.step-1");
const fieldsetTwo = document.querySelector(".calculator-container fieldset.step-2");
const fieldsetThree = document.querySelector(".calculator-container fieldset.step-3");
const fieldsets = Array.from(document.querySelectorAll(".calculator-container fieldset"));
const yearList = document.querySelector(".calculator-container ul.list-select#year");
const dateList = document.querySelector(".calculator-container ul.list-select#shipping_date");

const inputsStepTwo = Array.from(document.querySelectorAll("fieldset.step-2 input[type='text']"))

const paginationStepsWrap = document.querySelector(".calculator-pagination")
const paginationSteps = Array.from(document.querySelectorAll(".calculator-pagination div"));
const paginationStepOne = document.querySelector(".calculator-pagination div.pag-step-1");
const paginationStepTwo = document.querySelector(".calculator-pagination div.pag-step-2");

// step one fields
const field_city_from = document.querySelector("#city_from");
let cityFromList = document.querySelector("#city_select");
const field_city_to = document.querySelector("#city_to");
let cityToList = document.querySelector("#city_select_to");
var city_to_input = $('#city_to');
const city_error_message = "Please enter a valid Zip or City";
const city_span_to = $(".city_error_to");
const city_span_from = $(".city_error_from");
const field_valuation = document.querySelector("#mc_valuation");
const valuation_error_message = "Please enter motorcycle valuation";
const valuation_span_error = $(".valuation_error");
let valuationList = document.querySelector("#mc_select_valuation");



// step two fields
const field_year = document.querySelector("#selected_year");
const year_error_message = "Please enter vehicle year";
const year_span = $(".year_error");
const field_vehicle = document.querySelector("#selected_vehicle");
const vehicle_error_message = "Please enter vehicle make";
const vehicle_span = $(".vehicle_error");
const field_model = document.querySelector("#selected_vehicle_model");
const model_error_message = "Please enter vehicle model";
const model_span = $(".model_error");

// step three fields
const field_mail = document.querySelector("#email_address");
const mail_error_message = "Please enter a valid email address";
const mail_span = $(".mail_error")
const field_date = document.querySelector("#selected_shipping_date");
const date_error_message = "Please select a pickup period";
const date_span = $(".date_error");
const field_datepicker = document.querySelector("#datepicker");
const datepicker_error_span = $(".datepicker_error");
const datepicker_error_message = "Please enter a valid date";

const isRequired = (field) => (field.value.length === 0 ? false : true);

const checkField = (field, message, span) => {
    let valid = false;

    if (!isRequired(field)) {
        $(span).text(message);
    } else {
        $(span).text("");
        valid = true;
    }
    if (field.value === "Select") {
        $(span).text(message);
        valid = false;
    }
    return valid;
};

const isSameValue = (field1, field2, span) => {
    return field1.value === field2.value;
};

function getIsOnList(field, list, message, span)
{
    let valid = false;
    $(span).text(message);

    Array.from(list.children).forEach((item) => {
        if (item.textContent === field.value) {
            $(span).text("");
            valid = true;
        }
    });

    return valid;
}

//handle step 1
$(buttonStepOne).on("click", function (e) {
    const field1 =
        checkField(field_city_to, city_error_message, city_span_to) &&
        getIsOnList(
            field_city_to,
            cityToList,
            city_error_message,
            city_span_to
        );

    const field2 =
        checkField(field_city_from, city_error_message, city_span_from) &&
        getIsOnList(
            field_city_from,
            cityFromList,
            city_error_message,
            city_span_from
        );

    let field3 = true;
    // validate extra field
    if (field_valuation) {
        field3 =
            checkField(
                field_valuation,
                valuation_error_message,
                valuation_span_error
            ) &&
            getIsOnList(
                field_valuation,
                valuationList,
                valuation_error_message,
                valuation_span_error
            );
    }

    if (isSameValue(field_city_from, field_city_to)) {
        $(city_span_to).text("Please enter at least 1 zip code");
        return;
    }

    if (!field1 || !field2 || !field3) {
        return;
    }

    handleStepOne(e);
});

function handleStepOne(e)
{
    e.preventDefault();
    buttonStepOne.setAttribute("disabled", true);
    fieldsetOne.classList.add("d-none");
    fieldsetTwo.classList.remove("d-none");
    paginationStepsWrap.classList.remove("d-none");
    if (paginationSteps.length > 0) {
        paginationSteps[0].classList.add("checked");
        paginationSteps[1].classList.add("active");
    }
}

//handle step 2
$(buttonStepTwo).on("click", function (e) {
    e.preventDefault();
    const notOperable = document.querySelector(".operable-check #non-running");

    const field1 = checkField(field_year, year_error_message, year_span);
    const field2 = checkField(field_vehicle, vehicle_error_message, vehicle_span);
    const field3 = checkField(field_model, model_error_message, model_span);

    if (!field1 || !field2 || !field3 || (notOperable && notOperable.checked)) {
        return;
    }

    handleStepTwo(e);
});

function handleStepTwo(e)
{
    e.preventDefault();
    fieldsetTwo.classList.add("d-none");
    fieldsetThree.classList.remove("d-none");
    if (paginationSteps) {
        paginationSteps[1].classList.add("checked");
        paginationSteps[2].classList.add("active");
    }
    $(buttonStepTwo).removeClass("disabled");
}

    //handle step 3
    $(buttonStepThree).on('click', checkStepThree);

function checkStepThree(e)
{
    const field1 = checkField(field_mail, mail_error_message, mail_span);
    const field2 = checkField(field_date, date_error_message, date_span);
    let field3 = true;
    if (field_datepicker && window.innerWidth < 576 || field_datepicker.value ) {
        field3 = checkField(field_datepicker, datepicker_error_message, datepicker_error_span);
    }

    if (!field1 || !field2 || !field3) {
        return false;
    } else {
        return true;
    }
}


paginationStepOne && paginationStepOne.addEventListener("click", (e) => handlePaginationStep(0))
paginationStepTwo && paginationStepTwo.addEventListener("click", (e) => handlePaginationStep(1))

const inputWraps = Array.from(document.querySelectorAll(".input-wrap-list"))

//Click outside
window.addEventListener("click", function (e) {
    inputWraps.forEach((el, i) => {
        if (!el.contains(e.target)) {
            const ul = el.querySelector("ul");
            const input = el.querySelector("input");

            if (!ul.classList.contains("d-none")) {
                ul.classList.add("d-none");
            }
        }
    });
});

//changing steps on pagination buttons
function handlePaginationStep(stepNumber)
{
    fieldsets.forEach((item) => item.classList.add("d-none"));
    fieldsets[stepNumber].classList.remove("d-none");
    if (stepNumber == 0) {
        paginationSteps.forEach((item) => {
            item.classList.remove("checked");
            item.classList.remove("active");
        });
        buttonStepOne.removeAttribute("disabled");
        paginationSteps[stepNumber].classList.add("active");
    } else {
        paginationSteps[2].classList.remove("active");
        paginationSteps[stepNumber].classList.remove("checked");
    }
}

var phoneInput = document.getElementById("telephone");
if (phoneInput) {
    Inputmask({ "mask": "(999) 999-9999", showMaskOnHover: false }).mask(phoneInput);
}
function handleSubmitVehicleForm(params)
{
    var filter = $('#calculator_form');
    $.ajax({
        url: filter.attr('action'),
        data: filter.serialize(), // form data
        type: filter.attr('method'), // POST
        beforeSend: function (xhr) {
            console.log(xhr);
            filter.find('button.button-step-3').text('Calculating'); // changing the button label
            filter.find('button.button-step-3').addClass("sending");
        },
        success: function (response) {
            filter.find('button.button-step-3').text('Calculate cost'); // changing the button label back
            filter.find('button.button-step-3').removeClass("sending");
            $("#response").html(response);


        },
    });
    return false;
}
$('#calculator_form').on('submit', handleSubmitVehicleForm);

function emailValidation(params)
{
    var filter = $('#calculator_form');
    $.ajax({
        url: filter.attr('action'),
        data: filter.serialize(), // form data
        type: filter.attr('method'), // POST
        beforeSend: function (xhr) {
            $('button.button-step-3').prop("disabled", true);
        },
        success: function (response) {
            var emailValidation = JSON.parse(response);
            if (emailValidation.val == false) {
                $('.mail_error').text('Please enter a valid email address!');
                $('#email_address').attr('value', '');
                $('button.button-step-3').prop("disabled", true);
            } else {
                $('#email_address').attr('value', emailValidation.email);
                $('button.button-step-3').prop("disabled", false);
            }
            $('#hidden-form').attr('value', 'calculator');
        },
        complete: function () {
        },
    });
    return false;
}

  $('#calculator_form').on('focusout', '#email_address', function () {
      $('#hidden-form').attr('value', 'email_calculator');
      emailValidation();
  });


//motor form
  function handleSubmitMotorForm()
  {
      var filter = $('#mc_calculator_form');
      $.ajax({
            url: filter.attr('action'),
            data: filter.serialize(), // form data
            type: filter.attr('method'), // POST
            beforeSend: function (xhr) {
                console.log(xhr);
                filter.find('button.button-step-3').text('Calculating'); // changing the button label
                filter.find('button.button-step-3').addClass("sending");
            },
            success: function (response) {
                filter.find('button.button-step-3').text('Calculate cost'); // changing the button label back
                filter.find('button.button-step-3').removeClass("sending");
                $("#response").html(response);
            },
        });
      return false;
  }

  function emailValidationMotor(params)
  {
      var filter = $('#mc_calculator_form');
      $.ajax({
            url: filter.attr('action'),
            data: filter.serialize(), // form data
            type: filter.attr('method'), // POST
            beforeSend: function (xhr) {
                $('button.button-step-3').prop("disabled", true);
            },
            success: function (response) {
                var emailValidation = JSON.parse(response);
                if (emailValidation.val == false) {
                    $('.mail_error').text('Please enter a valid email address!');
                    $('#email_address').attr('value', '');
                    $('button.button-step-3').prop("disabled", true);
                } else {
                    $('#email_address').attr('value', emailValidation.email);
                    $('button.button-step-3').prop("disabled", false);
                }
                $('#hidden-form').attr('value', 'mc_calculator');
            },
            complete: function () {
            },
        });
      return false;
  }
  $('#mc_calculator_form').on('submit', handleSubmitMotorForm);

  $('#mc_calculator_form').on('focusout', '#email_address', function () {
    $('#hidden-form').attr('value', 'email_calculator');
    emailValidationMotor();
  });

  inputsStepTwo && inputsStepTwo.forEach(el => el.addEventListener("input", validateSecondStep))
  inputsStepTwo && inputsStepTwo.forEach(el => el.addEventListener("blur", validateSecondStep))

  function validateSecondStep(params)
  {

      if (field_year.value === "") {
          $("#selected_vehicle").attr("disabled", true);
          $("#selected_vehicle_model").attr("disabled", true);
      }
      if (field_year.value !== "") {
          $("#selected_vehicle").removeAttr("disabled", true);
          $("#selected_vehicle_model").removeAttr("disabled", true);
      }
  }

  let numPattern = /^(\d){5,}$/;
  let letterPattern = /^[a-zA-Z, ]{3,}$/;

  function setCityFrom()
  {
      var selected_value = $("#city_select");
      var city_from_input = $("#city_from");
      let city_from_list = document.querySelector("#city_select");
      let current_val;

      if (selected_value) {
          $(selected_value).on("click", function (e) {
            if (e.target === city_from_list) {
                return;
            }
            $(city_from_input).val(e.target.innerText);
            $(selected_value).addClass("d-none");
            current_val = e.target.innerText
          });
      }

      $(city_from_input).on("focus", function () {
        current_val = $(this).val()
        $(this).val("");
      })


      $(city_from_input).on("input", function () {
        current_val = $(this).val();
        $('#city_select_to').addClass("d-none");
        $(selected_value).removeClass("d-none");
        city_span_from.text("")

        if (letterPattern.test(current_val) || numPattern.test(current_val)) {
            getCityFrom(current_val, "city_select", city_from_input);
        }
      });

      $(city_from_input).on("focusout", function () {
        const firstChild = city_from_list.firstElementChild;
        const firstOption = firstChild && firstChild.textContent.toLowerCase();
        const value = $(city_from_input).val().toLowerCase().replace(" ,", ",");
        const includes = firstOption.includes(value);
        if (includes) {
            $(city_from_input).val(firstChild.textContent)
        }

        if ($(city_from_input).val()) {
            $(this).val($(city_from_input).val());
        } else {
            $(this).val(current_val);
        }
      })

  }
  setCityFrom();

  function setCityTo()
  {
      var selected_value = $('#city_select_to');
      let current_val;
      let city_to_list = document.querySelector("#city_select_to");

      if (selected_value) {
          $(selected_value).on('click', function (e) {
            if (e.target === city_to_list) {
                return;
            }
            $(city_to_input).val(e.target.innerText);
            $(selected_value).addClass("d-none");
            current_val = e.target.innerText
          })
      }

      $(city_to_input).on("focus", function () {
        current_val = $(this).val()
        $(this).val("");
      })

      $(city_to_input).on('input', function () {
        current_val = $(this).val();
        $(selected_value).removeClass("d-none");
        city_span_to.text("")

        if (letterPattern.test(current_val) || numPattern.test(current_val)) {
            getCityFrom(current_val, 'city_select_to');
        }
      })

      $(city_to_input).on("focusout", function () {
        const firstChild = city_to_list.firstElementChild;
        const firstOption = firstChild && firstChild.textContent.toLowerCase();
        const value = $(city_to_input).val().toLowerCase().replace(" ,", ",");
        const includes = firstOption.includes(value);
        if (includes) {
            $(city_to_input).val(firstChild.textContent)
        }
        if ($(city_to_input).val()) {
            $(this).val($(city_to_input).val());
        } else {
            $(this).val(current_val);
        }
      })
  }
  setCityTo();


  function setMcValuation()
  {
      var mc_select_valuation = $('#mc_select_valuation');
      var mc_valuation = $('#mc_valuation');
      if (valuationList) {
          const list = Array.from(valuationList.children);

          mc_valuation.on("focus", function (params) {
            $(mc_select_valuation).removeClass("d-none");

            let activeIndex = 0;

            list.map((item, index) => {
                item.className = "";

                if (item.innerText === mc_valuation.val()) {
                    item.classList.add("selected");
                    activeIndex = index;
                }
              });
            // select first if empty
            if (mc_valuation.val() === "") {
                list[0].classList.add("selected");
            }

            handleWithKeys(
                document.querySelector("#mc_valuation"),
                list,
                null,
                "#mc_select_valuation",
                activeIndex
            );
            valuation_span_error.text("")


            valuationList.addEventListener("mousedown", function (e) {
                mc_valuation.val(e.target.innerText)
                $(mc_select_valuation).addClass("d-none")
            })
          });

          mc_valuation.on("focusout", function (params) {
            $(mc_select_valuation).addClass("d-none");
          })
      }
  }
  setMcValuation();

/* YEAR INPUT */

  function setYear()
  {
      var selected_value = $("#year li");
      var year_input = $("#selected_year");
      var year_span_value = $(".input-value-year");
      var optionSelected;

      const yearUrl = motorCalculator ? "https://done.ship.cars/mc/makes/?year=" : "https://done.ship.cars/makes/?year="

      if (selected_value) {
          $(selected_value).on("click", function (e) {
            optionSelected = e.target.innerText;
            $(year_input).val(optionSelected);
            $(year_span_value).text(optionSelected);
            $(year_span_value).attr("data-placeholder", optionSelected);
            year_span.text("");
            setTimeout(() => {
                $("#year").addClass("d-none");
                getCarManufacture(
                    $(year_input).val(),
                    "select_vehicle",
                    yearUrl
                );
                $("#select_vehicle").removeClass("d-none");
            }, 200);
            validateSecondStep();
          });
      }

      $(year_input).on("focus", function (e) {
        $("#select_vehicle").addClass("d-none");
        $("#select_model").addClass("d-none");
        $("#year").removeClass("d-none");

        const list = Array.from(yearList.children).filter(
            (el) => !el.classList.contains("d-none")
        );

        // select item in the list
        let activeIndex = 0;

        list.map((item, index) => {
            item.className = "";

            if (item.innerText === year_span_value.text()) {
                item.classList.add("selected");
                activeIndex = index;
            }
          });

        // select first if empty
        if (year_input.val() === "") {
            list[0].classList.add("selected");
        }

        handleWithKeys(
            document.querySelector("#selected_year"),
            document.querySelectorAll("#year li"),
            year_span_value,
            "#year",
            activeIndex
        );
      });

      dropdownSearch("#selected_year", "#year li");

      handleOnInput(
          document.querySelector("#selected_year"),
          yearList,
          document.querySelectorAll("#year li"),
          year_span_value,
          "#year"
      );

      $(year_input).on("keydown", function (e) {
        if (e.key === "Enter") {
            setTimeout(() => {
                $("#year").addClass("d-none");

                getCarManufacture(
                    $(year_input).val(),
                    "select_vehicle",
                    yearUrl
                );
                $("#select_vehicle").removeClass("d-none");
            }, 200);
        }
      });

  }

  setYear();

/* VEHICLE INPUT */

  function setVehicle()
  {
      var selected_value = $("#select_vehicle");
      var vehicle_input = $("#selected_vehicle");
      let vehicle_list = document.querySelector("#select_vehicle");
      var vehicle_span_value = $(".input-value-vehicle");
      const modelUrl = motorCalculator ? "https://done.ship.cars/mc/models/" : "https://done.ship.cars/models/"


      if (selected_value) {
          $(selected_value).on("click", function (e) {
            if (e.target === vehicle_list) {
                return;
            }
            var optionSelected = e.target.innerText;
            $(vehicle_input).val(optionSelected);
            $(vehicle_span_value).text(optionSelected);
            $(vehicle_span_value).attr("data-placeholder", optionSelected);
            $(selected_value).addClass("d-none");
            $("#select_model").removeClass("d-none");
            vehicle_span.text("");
            setTimeout(() => {
                $(selected_value).addClass("d-none");
                getCarModels(
                    $(vehicle_input).val(),
                    $("#selected_year").val(),
                    "select_model",
                    modelUrl
                );
            }, 200);
          });
      }

      $(vehicle_input).on("keydown", function (e) {
        if (e.key === "Enter") {
            setTimeout(() => {
                $(selected_value).addClass("d-none");
                getCarModels(
                    $(vehicle_input).val(),
                    $("#selected_year").val(),
                    "select_model",
                    modelUrl
                );
            }, 200);
        }

      });
      //click on disabled vehicle field
      const vehicleWrap = document.querySelector(".input-wrap-vehicle");
      vehicleWrap && vehicleWrap.addEventListener("click", function (e) {
        const input  = vehicleWrap.querySelector("#selected_vehicle");
        if (input.hasAttribute("disabled")) {
            checkField(field_year, year_error_message, year_span);
        }
      })

      $(vehicle_input).on("focus", function () {
        $("#year").addClass("d-none");
        $("#select_model").addClass("d-none");
        $(selected_value).removeClass("d-none");

        const list = Array.from(vehicle_list.children).filter(
            (el) => !el.classList.contains("d-none")
        );
        // select item in the list
        let activeIndex = 0;

        list.map((item, index) => {
            item.className = "";

            if (item.innerText === vehicle_span_value.text()) {
                item.classList.add("selected");
                activeIndex = index;
            }
          });

        // select first if empty
        if (vehicle_input.val() === "") {
            list[0].classList.add("selected");
        }
      });

      dropdownSearch("#selected_vehicle", "#select_vehicle li");
  }

  setVehicle()


  function setVehicleEventListeners()
  {
      let vehicle_input = $("#selected_vehicle");
      let vehicle_span_value = $(".input-value-vehicle")
      let vehicleList = Array.from(document.querySelector("#select_vehicle").children);
      let selected = document.querySelector("#selected_vehicle");
      const list = vehicleList.filter(
          (el) => !el.classList.contains("d-none")
      );

      $(vehicle_input).on("input", function () {
        if (vehicleList.length === 0) {
            return;
        }

        handleWithKeys(
            selected,
            vehicleList,
            vehicle_span_value,
            "#select_vehicle"
        );
      });

      $(vehicle_input).on("focus", function () {
        if (vehicleList.length === 0) {
            return;
        }
        let activeIndex = 0;
        list.map((item, index) => {
            item.className = "";

            if (item.innerText === vehicle_span_value.text()) {
                item.classList.add("selected");
                activeIndex = index;
            }
          });

        handleWithKeys(
            selected,
            vehicleList,
            vehicle_span_value,
            "#select_vehicle",
            activeIndex
        );
      });

      field_vehicle.focus();
  }


  function setVehicleModel()
  {

      var selected_value = $('#select_model');
      var vehicle_model_input = $('#selected_vehicle_model');
      let model_list = document.querySelector("#select_model");
      var vehicle_model_span = $('.input-value-model');

      if (selected_value) {
          $(selected_value).on('click', function (e) {
            if (e.target === model_list) {
                return;
            }
            var optionSelected = e.target.innerText;
            $(selected_value).addClass("d-none");
            $(vehicle_model_input).val(optionSelected);
            $(vehicle_model_span).text(optionSelected);
            $(vehicle_model_span).attr("data-placeholder", optionSelected);
          })
      }

      $(vehicle_model_input).on("focus", function () {
        $(selected_value).removeClass("d-none");
        model_span.text("")
      })

        //click on disabled model field
        const modelWrap = document.querySelector(".input-wrap-model");
        modelWrap && modelWrap.addEventListener("click", function (e) {
            const input  = modelWrap.querySelector("#selected_vehicle_model");
            if (input.hasAttribute("disabled")) {
                checkField(field_year, year_error_message, year_span);
            }
        })


      dropdownSearch("#selected_vehicle_model", "#select_model li")
  }
  setVehicleModel();

  function setModelEventListeners(params)
  {
      const modelList = Array.from(document.querySelector("#select_model").children);
      const vehicle_model_span = $('.input-value-model');
      const modelInput = $("#selected_vehicle_model");
      const selected = document.querySelector("#selected_vehicle_model");
      const list = modelList.filter(
          (el) => !el.classList.contains("d-none")
      );

      $(modelInput).on("input", function () {
        if (modelList.length === 0) {
            return;
        }

        handleWithKeys(
            selected,
            modelList,
            vehicle_model_span,
            "#select_model"
        );
      });

      $(modelInput).on("focus", function () {
        if (modelList.length === 0) {
            return;
        }

        let activeIndex = 0;
        list.map((item, index) => {
            item.className = "";

            if (item.innerText === vehicle_model_span.text()) {
                item.classList.add("selected");
                activeIndex = index;
            }
          });

        handleWithKeys(
            selected,
            modelList,
            vehicle_model_span,
            "#select_model",
            activeIndex
        );
        buttonStepTwo.classList.remove("btn-disabled")
      });

      field_model.focus();
  }


//submit form on enter - last step
  const emailVehicle = document.querySelector("#calculator_form #email_address");
  const emailMotor = document.querySelector("#mc_calculator_form #email_address");
  const phoneVehicle = document.querySelector("#calculator_form #telephone");
  const phoneMotor = document.querySelector("#mc_calculator_form #telephone");

  emailVehicle&&emailVehicle.addEventListener("keyup", function (e) {
    if (e.key === "Enter") {
        checkStepThree();
    }
  });

  emailMotor&&emailMotor.addEventListener("keyup", function (e) {
    if (e.key === "Enter") {
        checkStepThree();
    }
  });

  phoneVehicle&&phoneVehicle.addEventListener("keyup", function (e) {
    if (e.key === "Enter") {
        checkStepThree();
        if (checkStepThree()) {
            handleSubmitVehicleForm();
        }
    }
  });

  phoneMotor&&phoneMotor.addEventListener("keyup", function (e) {
    if (e.key === "Enter") {
        checkStepThree();
        if (checkStepThree()) {
            handleSubmitMotorForm();
        }
    }
  });

  $(field_mail).on("focus", function (params) {
    mail_span.text("");
  });


/*SHIPPING DATE */
  function shipping_date()
  {
      let shippingDateListItems = $("#shipping_date li");
      let selectedDateInput = $("#selected_shipping_date");
      let selectedDateSpan = $(".input-value-date");
      let datepicker = $("#datepicker");

      if (shippingDateListItems) {
          // reflect same value to hidden field
          if (dateList) {
              handleWithKeys(
                  document.querySelector("#selected_shipping_date"),
                  Array.from(dateList.children),
                  $(".input-value-date")
              );
          }

          $(shippingDateListItems).on("mousedown", function () {
            selectedDateSpan.text($(this).attr("data-value"));
            clearSelectedItem();
            $(this).addClass("selected");
            setDate();
          });

          $(selectedDateInput).on("focus", function (e) {
            $("#shipping_date").removeClass("d-none");
            date_span.text("");

            selectedDateInput.val(selectedDateSpan.text());
            selectedDateSpan.text();

          });

          $(selectedDateInput).on("focusout", function (e) {
            setDate();
          });
      }

      function clearSelectedItem()
      {
          Array.from(dateList.children).forEach(
              (el) =>
              el.classList.remove("selected")
          );
      }

      function getConvertedValue(value)
      {
          switch (value) {
              case "asap":
                  return "As soon as possible";
              case "2weeks":
                  return "Within 2 Weeks";
              case "30days":
                  return "Within 30 Days";
              case "over30days":
                  return "More than 30 Days";
          }
      }

      if (window.innerWidth < 576) {
          $("#datepicker-label").text("I prefer to ship on");
          $(".date-input-wrap").addClass("d-none")
          handleDatepicker()
      }


      function setDateToInput(value, extraDays = 0)
      {
          const date = moment(new Date())
            .add(extraDays, "days")
            .format("YYYY-MM-DD");
          // hide datepicker
          $(".datepicker-wrap").addClass("d-none");
          $(selectedDateInput).val(date);
          $(selectedDateSpan).text(getConvertedValue(value));
          $(selectedDateSpan).attr("data-placeholder", getConvertedValue(value));
      }

      function handleDatepicker()
      {
          $(".datepicker-wrap").removeClass("d-none");

          $(datepicker).datepicker({
                dateFormat: "mm/dd/yy",
                minDate: 0,
                showOtherMonths: true,
                selectOtherMonths: true,
            });

          // use value after init
          $(selectedDateInput).val($(datepicker).val());
          $(selectedDateSpan).text("More than 30 days");
          // handle change
          $(datepicker).on("change", function () {
            $(selectedDateInput).val(moment($(this).val()).format("YYYY-MM-DD"));
            datepicker_error_span.text("");
          });
      }

      function setDate()
      {
          $("#shipping_date").addClass("d-none");
          var value = $(".step-3 .selected").attr("data-value");

          switch (value) {
              case "asap":
                  setDateToInput(value);
                  break;
              case "2weeks":
                  setDateToInput(value, 14);
                  break;
              case "30days":
                  setDateToInput(value, 30);
                  break;
              case "over30days":
                  $(selectedDateSpan).attr("data-placeholder", "More than 30 days");
                  handleDatepicker()
                  break;
          }
      }
  }

  shipping_date();

  function getCarManufacture(value, select, api, callback)
  {
      // https://done.ship.cars/makes/?year=
      let dropdown = document.getElementById(select);
      dropdown.innerHTML = "";
      let defaultOption = document.createElement('li');
      defaultOption.text = 'Select';
      dropdown.appendChild(defaultOption);
      dropdown.selectedIndex = 0;
      const url = api + value;
      const request = new XMLHttpRequest();

      request.open('GET', url, true);
      request.setRequestHeader('Content-type', 'application/json');
      request.onload = function () {
        if (request.status === 200) {
            const data = JSON.parse(request.responseText);
            if (data.length === 0) {
                let noData = document.createElement('li');
                noData.innerText = 'No results found';
                dropdown.appendChild(noData);
                noData.setAttribute("data-results", "no-results");
            }
            let option;
            for (let i = 0; i < data.length; i++) {
                defaultOption.remove();
                option = document.createElement('li');
                option.innerText = data[i].make;
                dropdown.appendChild(option);
            }
            // add event listeners after data is fetched
            setVehicleEventListeners();
            dropdown.firstElementChild.classList.add("selected");
        } else {
            // Reached the server, but it returned an error
        }
      }

        request.onerror = function () {
            console.error('An error occurred fetching the JSON from ' + url);
        };

        request.send();
  }

  function getCarModels(make, year, select, api)
  {
      // https://done.ship.cars/models/
      let dropdown = document.getElementById(select);
      dropdown.innerHTML = "";
      let defaultOption = document.createElement('li');
      defaultOption.text = 'Select';
      dropdown.appendChild(defaultOption);
      dropdown.selectedIndex = 0;
      let param = '?year=' + year + '&make=' + make;
      const url = api + param.toString();
      const request = new XMLHttpRequest();
      request.open('GET', url, true);
      request.setRequestHeader('Content-type', 'application/json');
      request.onload = function () {
        if (request.status === 200) {
            const data = JSON.parse(request.responseText);
            let option;
            for (let i = 0; i < data.length; i++) {
                defaultOption.remove();
                option = document.createElement('li');
                option.innerText = data[i].model;
                dropdown.appendChild(option);
            }
            // add event listeners after data is fetched
            setModelEventListeners()
            dropdown.firstElementChild.classList.add("selected");
        } else {
            // Reached the server, but it returned an error
        }
      }

        request.onerror = function () {
            console.error('An error occurred fetching the JSON from ' + url);
        };

        request.send();
  }


  function getCityFrom(val, select)
  {
      let dropdown = document.getElementById(select);
      dropdown.innerHTML = "";
      let defaultOption = document.createElement('li');
      defaultOption.innerText = 'Loading..';
      dropdown.appendChild(defaultOption);
      dropdown.selectedIndex = 0;
      var myHeaders = new Headers();
      myHeaders.append("Content-Type", " application/vnd.api+json");
      if (isNaN(val)) {
          var raw = JSON.stringify({
                "city_state": {
                    "text": val,
                    "completion": {
                        "field": "citystate_suggest",
                        "fuzzy": {
                            "fuzziness": 0,
                        },
                        "size": 8,
                    },
                },
            });
      } else {
          raw = JSON.stringify({
                "city_state": {
                    "text": val,
                    "completion": {
                        "field": "name_suggest",
                        "fuzzy": {
                            "fuzziness": 0,
                        },
                        "size": 8,
                    },
                },
            });
      }


      var requestOptions = {
            method: 'POST',
            headers: myHeaders,
            body: raw,
            redirect: 'follow',
        };

        fetch("https://www.montway.com/es/gis/_suggest", requestOptions)
        .then(response => response.text())
        .then(result => {
            defaultOption.remove();

            let res = JSON.parse(result);
            let option;
            dropdown.innerHTML = '';
            for (let i = 0; i < res.city_state.length; i++) {
                for (let z = 0; z < res.city_state[i].options.length; z++) {
                    option = document.createElement('li');
                    option.classList.add('res');
                    option.innerText = res.city_state[i].options[z]._source.text;
                    dropdown.appendChild(option);
                }
            }
            handleWithKeys(field_city_from, Array.from(dropdown.children), null, "#city_select")
            handleWithKeys(field_city_to, Array.from(dropdown.children), null, "#city_select_to")
            if (dropdown.firstElementChild) {
                dropdown.firstElementChild.classList.add("selected");
            }
          })
        .catch(error => console.log('error', error));
  }

  function dropdownSearch(input, list)
  {
      $(input).on("input", function () {
        var value = $(this).val().toLowerCase();
        var dropdown = $(list);
        $(dropdown).each(function () {
            var text = $(this).text().toLowerCase();
            if (text.includes(value.trim())) {
                $(this).removeClass('d-none');
            } else {
                $(this).addClass('d-none');
            }
        })
      })
  }


  function handleOnInput(input, list, array, span, listParent)
  {
      $(input).on("input", function (params) {
        handleWithKeys(input, array, span, listParent)

        // if ( list.firstElementChild.classList.contains("d-none")) {
        //   list.firstElementChild.classList.remove("selected");
        // }
        if (list) {
            const filteredChildren = Array.from(list.children).filter(
                (el) => !el.classList.contains("d-none")
            );

            filteredChildren.forEach((el) => {
                if (el.classList.contains("selected")) {
                    el.classList.remove("selected");
                }
            });

            if (filteredChildren.length >= 1) {
                filteredChildren[0].classList.add("selected");
            }
        }
      })
  }

//allows for keyboard activity while input is in focus
  function handleWithKeys(input, list, span, listParent, indexToStart = 0)
  {
      const filtered = Array.from(list).filter(el => !el.classList.contains("d-none"))

      let [activeIndex, length] = [0, filtered.length];
      activeIndex = indexToStart

      input.addEventListener("keydown", handleKeyDown);

      function handleKeyDown(e)
      {
          const { key } = e;

          if (key === "ArrowDown") {
              moveDown(e);
          }
          if (key === "ArrowUp") {
              moveUp(e);
          }

          if (key === 'Enter') {
              e.preventDefault()
              insertText(e)
          }
      }

      function moveDown(e)
      {
          activeIndex = activeIndex + 1;

          if (activeIndex > filtered.length - 1) {
              activeIndex = filtered.length - 1;
          }

          navigateThroughElement(activeIndex);
      }

      function moveUp(e)
      {
          if (activeIndex === 0) {
              activeIndex = 1;
          }
          activeIndex = (length + (activeIndex - 1)) % length;
          navigateThroughElement(activeIndex);
      }

      function navigateThroughElement(index)
      {
          filtered.forEach(el => {
                if (el.classList.contains('selected')) {
                    el.classList.remove('selected');
                }
            })
          filtered[index] && filtered[index].classList.add('selected');

          const scrollTop = $(".list-select").scrollTop()
          if (filtered[index]) {
              const elHeight = filtered[index].offsetHeight;
              const elOffset = activeIndex * elHeight
              if (elOffset < scrollTop) {
                  $(".list-select").scrollTop(elOffset);
              } else {
                  $(".list-select").scrollTop(elOffset - 3 * elHeight);
              }
          }
      }

      function insertText(e)
      {
          if (activeIndex >= 0) {
              input.value = filtered[activeIndex].innerText;
              if (span) {
                  $(span).text(filtered[activeIndex].innerText);
                  $(span).attr("data-placeholder", filtered[activeIndex].innerText);
              }

              input.blur();
              if (filtered[activeIndex].parentElement) {
                  filtered[activeIndex].parentElement.classList.add("d-none")
              }
          }
      }
  }

  $(".info-btn").on("click", function () {
    $(".info-tooltip").removeClass("d-none")
  })

  $(".info-close").on("click", function () {
    $(".info-tooltip").addClass("d-none")
  })

  $(".operable-btn").on("click", function () {
    $(".operable-tooltip").removeClass("d-none")
  })

  $(".operable-close").on("click", function () {
    $(".operable-tooltip").addClass("d-none")
  })

//focus privacy policy modal
  $('#modal-privacy').on('shown.bs.modal', function () {
    $('.privacy-modal .modal-body').trigger('focus')
  })
