@extends('layouts.app')

@section('content')
  <div class="container mt-5">
    @include('partials.page-header')
    @include('blocks.block-hero-help')
    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'sage') }}
      </div>
      {!! get_search_form(false) !!}
    @endif

    @php
      $page_id = get_queried_object_id();
      $cats = \App\Controllers\App::returnCPTcats('helpcenter-category');

      $term = get_queried_object();

    @endphp
    <h1 class="h2">{!! $term->name !!}</h1>

    <ul class="d-flex ">
      @foreach($cats['cat_id'] as $key => $cat)
        @if(isset($cats['cat_name'][$key]) && isset($cats['cat_id'][$key]))
          <li>
            <a href="{!! $cats['cat_url'][$key] !!}">{!! $cats['cat_name'][$key] !!}</a>
          </li>
        @endif
      @endforeach
    </ul>

    @while (have_posts()) @php the_post() @endphp
    @include('partials.content-'.get_post_type())
    @endwhile

  </div>
@endsection
