{{--
  Title: 2x2 Boxes with text V3
  Description: 2x2 Boxes with text V3
  Category: montway_blocks
  Icon: admin-comments
  Keywords: reviews rating
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/2x2-boxes-with-text.png
--}}
@php
  $title = get_field("title");
  $boxes = get_field("boxes");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

@endphp
<section data-{{ $block['id'] }} class="bg-light two-by-two">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if ( !empty( $title ) )
          <h2 class="mb-4 mb-lg-5">{!!$title!!}</h2>
        @endif
      </div>
      @foreach($boxes as $box)
        @php
          if(!empty($box['icon'])){
          $icon = \App\Controllers\App::imageWithAlt($box['icon']);
          $icon_type = \App\Controllers\App::checkImgExtension($box['icon']['filename']);
          }
        @endphp
        <div class="col-lg-6 mb-3 mb-lg-5 ">
            <div class="box-wrap box-icon-text bg-white box-v3 js-container-toggle">
              {{-- <div class="d-flex align-items-center mb-2 mb-lg-4">
                @if($icon_type == "svg")
                  <span class="icon-montway mr-3 d-block d-lg-none ">
                  @php
                    echo file_get_contents($icon['image'])
                  @endphp
                </span>
                @else
                  <img class="icon-montway" src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}"
                       srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
                @endif
              </div> --}}
              <div class="d-block d-lg-flex">

                @if($icon_type == "svg")
                  <span class="icon-montway d-none d-lg-block mr-4 ">
                  @php
                    echo file_get_contents($icon['image'])
                  @endphp
                </span>
                @else
                <span class="icon-montway d-none d-lg-block mr-4 ">
                  <img class="icon-montway" src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}"
                       srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
                </span>
                @endif
                <div>
                  <div class="d-flex align-items-center justify-content-between mb-lg-2">
                    <div class="d-flex align-items-center">
                      <img class="icon-montway d-block d-lg-none mr-3 mr-lg-0" src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}"
                           srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
                      <h3 class="h4">{!! $box['title'] !!}</h3>
                    </div>
                    <i class="icon icon-keyboard_arrow_right"></i>
                  </div>

                  <div class="text-wrap body-link">{!! $box['body_copy'] !!}</div>
                </div>
              </div>
            </div>
        </div>
      @endforeach
    </div>
  </div>
</section>
