{{--
Title: Bill of Lading
Description: Bill of Lading
Category: help_center_blocks
Icon: admin-comments
Keywords: text section
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/bill.png
--}}
@php
  $title = get_field('title');
  $subtitle = get_field('subtitle');
  $body_copy = get_field('body_copy');
  $box = get_field('icon');
  $padding = get_field("block_padding");

    $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
    echo $inline_style;
@endphp
<section class="col-12 bill-of-landing" data-{{ $block['id'] }}>
  <div class="bill-box">


    <h1 class="h2 mb-4 ">{!! $title !!}</h1>
    <h3 class=" mb-0 mb-lg-3 mb-4 text-normal">{!! $subtitle !!}</h3>
    <div class="box-icon-text has-border">
      <div class="d-flex align-items-center  mb-3 mb-lg-0">
        @php
          if(!empty($box)){
          $icon =  \App\Controllers\App::imageWithAlt($box);
          $icon_type =  \App\Controllers\App::checkImgExtension($box['filename']);
          }
          @endphp

        @if(isset($icon))
          <span class="box-icon p-absolute mr-3 mr-lg-0">
            @if($icon_type == "svg")
                    @php
                      echo file_get_contents($icon['image'])
                    @endphp
          @else
            <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}" srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
            @endif
          </span>
      @endif
    </div>
    <div class="text-gray body-copy-b ">{!! $body_copy !!}</div>
  </div>
</div>
</section>
