{{--
  Title: Blocks with icon & text
  Description: Blocks with icon & text
  Category: montway_blocks
  Icon: admin-comments
  Keywords: icons text blocks
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/4x2icon-text.png
--}}
@php

$title = get_field("title");
$boxes = get_field("boxes");
$padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

$blocks_layout = get_field("blocks_layout");

@endphp

@if($blocks_layout == "four_two")
<!-- 4x2 Block Layout here -->
<section data-{{ $block['id'] }} class="bg-gray-white">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
    </div>
    <div class="row">
      @foreach ($boxes as $box)
       <div class="col-lg-3">
         <div class="box-icon-text js-container-toggle">
        @php
            if(!empty($box['icon'])){
            $icon =  \App\Controllers\App::imageWithAlt($box['icon']);
            $icon_type =  \App\Controllers\App::checkImgExtension($box['icon']['filename']);
            }
        @endphp
         <div class="d-flex align-items-center justify-content-between ">
            <div class="d-flex flex-row flex-lg-column align-items-center align-items-lg-start">

              @if(isset($icon))
              @if($icon_type == "svg")
              <span class="icon-montway mr-3 mr-lg-0 mb-0 mb-lg-2">
                @php
                      echo file_get_contents($icon['image'])
                      @endphp
                  </span>
                  @else
                  <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}" srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
                  @endif
              @endif
                  <h3 class="h4 mb-0 mb-lg-3">{!! $box['title'] !!}</h3>
            </div>
            <i class="icon icon-keyboard_arrow_right"></i>
          </div>
            <div class="text-wrap body-link">
             {!! $box['body_copy'] !!}
            </div>
          </div>
        </div>
      @endforeach

    </div>
  </div>
</section>
@elseif($blocks_layout == "three_two")
        <!-- 3x2 Block Layout here -->
        <section data-{{ $block['id'] }} class="bg-white">
          <div class="container">
            <div class="row">
              <div class="col-12">
                <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
              </div>
            </div>
            <div class="row">
              @foreach ($boxes as $box)
               <div class="col-lg-4">
                 <div class="box-icon-text js-container-toggle">
                @php
                    if(!empty($box['icon'])){
                    $icon =  \App\Controllers\App::imageWithAlt($box['icon']);
                    $icon_type =  \App\Controllers\App::checkImgExtension($box['icon']['filename']);
                    }
                @endphp
                 <div class="d-flex align-items-center justify-content-between ">
                    <div class="d-flex flex-row flex-lg-column align-items-center align-items-lg-start">

                      @if(isset($icon))
                      @if($icon_type == "svg")
                      <span class="icon-montway mr-3 mr-lg-0 mb-0 mb-lg-2">
                        @php
                              echo file_get_contents($icon['image'])
                              @endphp
                          </span>
                          @else
                          <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}" srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
                          @endif
                      @endif
                          <h3 class="h4 mb-0 mb-lg-3">{!! $box['title'] !!}</h3>
                    </div>
                    <i class="icon icon-keyboard_arrow_right"></i>
                  </div>
                    <div class="text-wrap body-link">
                      {!! $box['body_copy'] !!}
                    </div>
                  </div>
                </div>
              @endforeach

            </div>
          </div>
        </section>
@else
      <!-- 2x2 Block Layout here -->
  <section data-{{ $block['id'] }} class="bg-light icon-text-shadows">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        </div>
      </div>
      <div class="row">
        @foreach ($boxes as $box)
         <div class="col-lg-6">
           <div class="box-icon-text with-shadow ">
          @php
              if(!empty($box['icon'])){
              $icon =  \App\Controllers\App::imageWithAlt($box['icon']);
              $icon_type =  \App\Controllers\App::checkImgExtension($box['icon']['filename']);
              }
          @endphp
           <div class="d-flex flex-column  justify-content-between ">
              <h3 class="h4 mb-0 mb-lg-3">{!! $box['title'] !!}</h3>
                <div class="d-flex flex-column flex-lg-row  align-items-start">
                  @if(isset($icon))
                    <span class="d-inline-block icon mr-0 mr-lg-5 mb-2 ">
                      <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}" srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
                    </span>
                  @endif
                    <div class="text-wrap body-link">
                        {!! $box['body_copy'] !!}
                    </div>
                 </div>
            </div>
          </div>
        </div>
        @endforeach

      </div>
    </div>
</section>
@endif