{{--
  Title: 4 boxes with no spacing
  Description: 4 boxes with no spacing
  Category: montway_blocks
  Icon: admin-comments
  Keywords: box boxes
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/boxes-no-spacing.png
--}}
@php
$title = get_field("title");
$boxes = get_field("boxes");
$padding = get_field("block_padding");

 $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-gray-white boxes-no-spacing">
  <div class="container">
    <div class="row">
      <div class="col-12">

        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
      <div class="col-12">
        <div class="cards-wrap">
          @foreach($boxes as $box)
          <a href="{!! $box['url'] !!}" class="text-box">

              @if($box['title'])
              <p class="mb-lg-4 h3">{!! $box['title'] !!}</p>
              @endif
              <i class="icon-arrow_forward icon"></i>

              @if($box['body_copy'])
              <div class="text-wrap">{!! $box['body_copy'] !!}</div>
              @endif
          </a>
          @endforeach
        </div>

      </div>
    </div>
  </div>
</section>
