{{--
  Title: Contact Sidebar and Form
  Description: Contact Sidebar and Form
  Category: montway_blocks
  Icon: admin-comments
  Keywords: contact sidebar
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/contact-us.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $informations = get_field('informations');
  $business_hours = get_field('business_hours');
@endphp
<section data-{{ $block['id'] }} class="contact-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-6 col-md-6 contact-form order-2 order-md-1">
        @php gravity_form( get_field('contact_form_shordcode'), false, false, false, null, true ); @endphp
      </div>
      <div class="col-xl-4 col-md-6 offset-xl-2 order-1 order-md-2">
        <div class="mb-5">
          <h2 class="h4 mb-3">{!! $informations['title'] !!}</h2>
          <div class="mb-3">{!! $informations['location'] !!}</div>
          <div class="phones">

            @foreach($informations['information'] as $information)
            <div class="d-flex justify-content-between has-gray-border py-2">
              <div class="d-flex align-items-center">
                <i class="icon"></i>
                <p class="text-gray">{!! $information['info'] !!}</p>
              </div>
              <a href="" class="is-underline">{!! $information['phone'] !!}</a>
            </div>
            @endforeach
          </div>
        </div>
        <div>

          <h2 class="h4 mb-2 mb-lg-3">{!! $business_hours['title'] !!}</h2>
          @foreach($business_hours['working_days'] as $hours)
            @php
              if(!empty($hours['icon'])){
              $image = \App\Controllers\App::imageWithAlt($hours['icon']);
              }
            @endphp
            <div class="d-flex justify-content-between has-gray-border py-2">
              <div class="text-gray">{!! $hours['days'] !!}</div>
              @if(!empty($image))
                <img class="chat-img" src="{!! $image['image'] !!}" alt="">
              @endif
              <p>{!! $hours['time'] !!}</p>
            </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</section>
