{{--
  Title: Counter Module
  Description: Counter Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: counter
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/counter.png
--}}
@php
$main_logo_id = get_field("main_logo");
$logos = get_field("logos");
$customers = get_field("customers");
$experience = get_field("experience");
$drivers = get_field("drivers");
$vehicles = get_field("vehicles");
$select_counter = get_field("select_counter");
$title = get_field("title");
$body_copy = get_field("body_copy");
$padding = get_field("block_padding");

  if(!empty($main_logo_id)){
  	$main_logo = \App\Controllers\App::imageWithAlt($main_logo_id);
    $main_logo_type = \App\Controllers\App::checkImgExtension($main_logo_id['filename']);
  }
  if(!empty($logos[0]['logo_image'])){
   foreach ($logos as $item) {
      $logos_img[] = \App\Controllers\App::imageWithAlt($item['logo_image']);
      $logos_img_type[] = \App\Controllers\App::checkImgExtension($item['logo_image']['filename']);
      $links[] = $item['link'];
  }
}
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
@endphp
@if($select_counter == "one_line")
<section data-{{ $block['id'] }} style="" class="counter-wrap-oneline counter-wrap-select">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if ( !empty( $title ) )
          <h2 class="mb-3">{!! $title !!}</h2>            
        @endif
      </div>
      <div class="col-lg-4 col-md-6 text-center counter-trigger mb-4 mb-md-0">
        <h3 class="number "><span class="counter" data-countend={!! $customers['number_of_customers'] !!}>{!! $customers['number_of_customers'] !!}</span><span class="plus">+</span></h3>
        <p>{!! $customers['copy_text'] !!}</p>
      </div>
      <div class="col-lg-4 col-md-6 text-center mb-4 mb-lg-0">
        <h3 class="number "><span class="counter" data-countend="{!! $experience['years'] !!}">{!! $experience['years'] !!}
          @if ( $experience['years'] != '[totalyears]')
           </span>
          @else
           </span><span class="plus">+</span> years
          @endif
        
        </h3>
        <p>{!! $experience['copy_text'] !!}</p>
      </div>

      <div class="col-lg-4 col-md-6 text-center">
        <h3 class="number " ><span class="counter" data-countend="{!! $drivers['drivers_number'] !!}">{!! number_format( $drivers['drivers_number'] ) !!}</span><span class="plus">+</span></h3>
        <p>{!! $drivers['copy_text'] !!}</p>
      </div>
    </div>
  </div>

</section>
@endif

@if($select_counter == "with_logos")
<section data-{{ $block['id'] }} style="background-image: url('{{ $main_logo['image'] }}');" class="counter-wrap counter-wrap-select">
  <div class="container">
    <div class="row">
      <div class="col-counter mx-auto position-relative">
        <div class="row">
          {{-- @if(isset($main_logo))
            @if($main_logo_type == "svg")
              @php
                echo file_get_contents($main_logo['image'])
              @endphp
            @else
            <img src="{!! $main_logo['image'] !!}" alt="{!! $main_logo['alt'] !!}" srcset="{!! $main_logo['small'] . $main_logo['medium'] . $main_logo['large'] !!}" />
            @endif
          @endif --}}
          @if( !empty( $logos_img ) )
          @php $i = 0; @endphp
          @foreach($logos_img as $key => $logo_img)
            <div class="col-4 position-absolute logo logo-{{ $i }} p-0">
              @if ($links[$key])
              <a href="{!! $links[$key] !!}" target="_blank" rel="noopener">
              @endif
                @if($logos_img_type[$key] == "svg")
                  @php
                    echo file_get_contents($logo_img['image'])
                  @endphp
                @else
                <img src="{!! $logo_img['image'] !!}" alt="{!! $logo_img['alt'] !!}"  />
                @endif
                @if ($links[$key])
                </a>
                @endif
            </div>
            @php $i++ @endphp
          @endforeach
          @endif

          <div class="col-4 position-absolute customers text-center counter-trigger">
            <h3 class="number"><span class="counter" data-countend={!! $customers['number_of_customers'] !!}>{!! $customers['number_of_customers'] !!}</span><span class="plus">+</span></h3>
            <p>{!! $customers['copy_text'] !!}</p>
          </div>
          <div class="col-4 position-absolute years text-center">
            <h3 class="number"><span class="counter" data-countend="{!! $experience['years'] !!}">{!! $experience['years'] !!}</span><span>+</span><span> years</span></h3>
            <p>{!! $experience['copy_text'] !!}</p>
          </div>
          <div class="col-4 position-absolute drivers text-center">
            <h3 class="number"><span class="counter" data-countend="{!! $drivers['drivers_number'] !!}">{!! number_format( $drivers['drivers_number'] ) !!}</span><span class="plus">+</span></h3>
            <p>{!! $drivers['copy_text'] !!}</p>
          </div>
          <div class="col-4 position-absolute vehicels text-center">
            <h3 class="number"><span class="counter" data-countend="{!! $vehicles['vehicles_number'] !!}">{!! $vehicles['vehicles_number'] !!}</span><span class="plus">+</span></h3>
            <p>{!! $vehicles['copy_text'] !!}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endif


@if($select_counter == "numbers")
<section data-{{ $block['id'] }} style="" class="counter-wrap-2x2 counter-wrap-select">
  <div class="container">
    <div class="row">
      <div class="col-lg-4 pb-4">
        <h2 class="mb-32">{!! $title !!}</h2>
        <p>{!! $body_copy !!}</p>
      </div>

      <div class="col-lg-8">
        <div class="row">
          <div class="col-md-6 counter-trigger mb-md-5">
            <h3 class="number "><span class="counter" data-countend={!! $customers['number_of_customers'] !!}>{!! $customers['number_of_customers'] !!}</span><span class="plus">+</span></h3>
            <p class="copy-text">{!! $customers['copy_text'] !!}</p>
            <div class="body-copy text-gray">{!! $customers['body_copy'] !!}</div>
          </div>

          <div class="col-md-6  mb-md-5">
            <h3 class="number "><span class="counter" data-countend="{!! $experience['years'] !!}">{!! $experience['years'] !!}</span>+ years</h3>
            <p class="copy-text">{!! $experience['copy_text'] !!}</p>
            <div class="body-copy text-gray">{!! $experience['body_copy'] !!}</div>
          </div>

          <div class="col-md-6">
            <h3 class="number"><span class="counter" data-countend="{!! $vehicles['vehicles_number'] !!}">{!! $vehicles['vehicles_number'] !!}</span><span class="plus">+</span></h3>
            <p class="copy-text">{!! $vehicles['copy_text'] !!}</p>
            <div class="body-copy text-gray">{!! $vehicles['body_copy'] !!}</div>
          </div>

          <div class="col-md-6">
            <h3 class="number" ><span class="counter" data-countend="{!! $drivers['drivers_number'] !!}">{!! number_format( $drivers['drivers_number'] ) !!}</span><span class="plus">+</span></h3>
            <p class="copy-text">{!! $drivers['copy_text'] !!}</p>
            <div class="body-copy text-gray">{!! $drivers['body_copy'] !!}</div>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
@endif
