{{--
  Title: Call to Action (logo and text on the left, image to the right)
  Description: Call to action block
  Category: montway_blocks
  Icon: admin-comments
  Keywords: cta action call
  Mode: edit
  Align: center
  PostTypes: page post help-center
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/cta-logo-left.png
--}}
@php
if(isset($page_id)){
    	$text = get_field("title_cta2", $page_id);
      $button = get_field("button_cta2", $page_id);
      $logo_id = get_field("logo_cta2", $page_id);
      $background_image_id = get_field("background_image_cta2", $page_id);
      $padding = get_field("block_padding_cta2", $page_id);
      $button_type = get_field('button_type', $page_id);
      $gravity_form = get_field('contact_form_shordcode', $page_id);
}else{
      $text = get_field("title_cta2");
      $button = get_field("button_cta2");
      $logo_id = get_field("logo_cta2");
      $background_image_id = get_field("background_image_cta2");
      $padding = get_field("block_padding_cta2");
      $button_type = get_field('button_type');
      $gravity_form = get_field('contact_form_shordcode');
}
    if(!isset($block['id'])){
    	  $block['id'] = 'h46hbgyu';
    }

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

if(!empty($logo_id)){
	$logo = \App\Controllers\App::imageWithAlt($logo_id);
	$logo_type = \App\Controllers\App::checkImgExtension($logo_id['filename']);
}

if(!empty($background_image_id)){
	$background = \App\Controllers\App::imageWithAlt($background_image_id);
	$background_type = \App\Controllers\App::checkImgExtension($background_image_id['filename']);
}
$form_cta = get_field('contact_form_shordcode');
$form = GFAPI::get_form( $form_cta );
@endphp
@if ($form['title'] == 'Let\'s get Started')
<div class="modal form-modal home-delivery-form" id="formModal-{{$form_cta}}" tabindex="-1" aria-labelledby="formModal-{{$form_cta}}" aria-hidden="true">
  <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body contact-form p-0">
        <div class="container-fluid">
          <div class="row">
            <div class="left-content cus-col-6">
              <div class="modal-text">
                <h2 class="text-white">Find out how our Vehicle Home Delivery solution and Montway Business Portal can:</h2>
                <ul class="bulleted-list mt-4">
                  <li class="text-white"><h3 class="text-white">expand your sales audience</h3></li>
                  <li class="text-white"><h3 class="text-white">engage motivated consumers</h3></li>
                  <li class="text-white"><h3 class="text-white">drive increased sales</h3></li>
                  <li class="text-white"><h3 class="text-white">simple and easy dealer website integration</h3></li>
                </ul>
              </div>
              <div class="modal-logos d-flex justify-content-between align-items-center">
                <img src="/app/uploads/2022/02/bbb-logo-transparent.png" alt="bbb-logo">
                <img src="/app/uploads/2022/02/naaa_white_logo.png" alt="naaa" style="height: 60px;">
                <img src="/app/uploads/2022/02/iara_white_logo.png" alt="iara">
              </div>
            </div>
            <div class="right-content cus-col-6">
              @php gravity_form( $form_cta , true, true, false, null, true ); @endphp
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@else
<div class="modal form-modal" id="formModal-{{$form_cta}}" tabindex="-1" aria-labelledby="formModal-{{$form_cta}}" aria-hidden="true">
  <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body contact-form contact-form-btn">
        @php gravity_form( $form_cta , true, false, false, null, true ); @endphp
      </div>
    </div>
  </div>
</div>
@endif
<section data-{{ $block['id'] }} class="cta-logo-btn bg-white position-relative">
  <div class="position-relative">
    <div class="img-wrap">

      @if(isset($background))
      @if($background_type == "svg")
      @php
          echo file_get_contents($background['image'])
          @endphp
      @else
      <img src="{!! $background['image'] !!}" alt="{!! $background['alt'] !!}"  />
      @endif
      @endif
    </div>
    @if($button_type == 'shortcode')
      <button class="button-orange small" data-toggle="modal" data-target="#formModal-{{$form_cta}}">{!! $button['button_text'] !!}</button>
    @else
      <a href="{!! $button['button_link'] !!}" class="button-orange small">{!! $button['button_text'] !!}</a>
    @endif
    <div class="text-wrap">
      <div class="container">
        <div class="row align-items-end justify-content-between">
          <div class="col-8 col-md-8 col-lg-8">
              <div class="logo-text d-none">
                @if(isset($logo))
                @if($logo_type == "svg")
                @php
                  echo file_get_contents($logo['image'])
                  @endphp
                @else
                <div class="img-wrap pr-1 pr-md-4">
                  <img src="{!! $logo['image'] !!}" alt="{!! $logo['alt'] !!}" />
                </div>
                @endif
                @endif
                @if ( !empty( $text ) )
                  <h2 class="text-white cta-text">{!! $text !!}</h2>
                @endif
              </div>


          </div>
          <div class="col-md-4 text-right">

          </div>

        </div>
      </div>
    </div>
    <div class="container mt-4 mt-lg-0">
      <div class="row">
        <div class="col-12">
          @if($button_type == 'shortcode ')
            <button class="button-orange small mobile" data-toggle="modal" data-target="#formModal-f">{!! $button['button_text'] !!}</button>
          @else
            <a href="{!! $button['button_link'] !!}" class="button-orange small mobile">{!! $button['button_text'] !!}</a>
          @endif
        </div>
      </div>
    </div>
  </div>
</section>
