{{--
  Title: Images in circles and text beside V2
  Description: Images in circles and text beside V2
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/images-circle-text-beside-v2.png
--}}
@php
$title = get_field("c_title");
$subtitle = get_field("c_subtitle");
$sections = get_field("single_section");
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
$image_position = get_field('image_position');
echo $inline_style;
if($image_position == "left"){
	$counter = 0;
}else{
	$counter = 1;
}

@endphp
<section data-{{ $block['id'] }} class="bg-white circle-img-text list-style-blue">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if(!empty($title))
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        @endif
        @if(!empty($subtitle))
        <div class="p mb-5 body-link">{!! $subtitle !!}</div>
        @endif
      </div>
    </div>
  </div>
@foreach($sections as $section)
@if($counter % 2 == 0)
    <div class="container mb-32">
      <div class="row align-items-center">
        <div class="col-12 col-md-6 pr-md-4">
            <div>
              @php
                if(!empty($section['image'])){
                $img = \App\Controllers\App::imageWithAlt($section['image']);
                $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
              @endphp
              @if(isset($img))
                @if($img_type == "svg")
                  @php
                    echo file_get_contents($img['image'])
                  @endphp
                @else
                  <img class="spec-width-532" src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}" srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                @endif
              @endif
            </div>
        </div>
         <div class="col-md-6">
            <div>
              @if(isset($section['title']))
              <h2 class="mb-4 mb-xl-5">{!! $section['title'] !!}</h2>
              @endif
              @if(isset($section['body_copy']))
              <div class="body-link">{!! $section['body_copy'] !!}</div>
              @endif
            </div>
        </div>
      </div>
    </div>
  @else
      <div class="container mb-32">
        <div class="row align-items-center">

          <div class="col-md-6 order-2 order-md-1">
            <div>
              @if(isset($section['title']))
                <h2 class="mb-4 mb-xl-5">{!! $section['title'] !!}</h2>
              @endif
              @if(isset($section['body_copy']))
                <div class="body-link">{!! $section['body_copy'] !!}</div>
              @endif
            </div>
          </div>
          <div class="col-12 col-md-6 order-1 pl-md-4">
            <div>
              @php
                if(!empty($section['image'])){
                $img = \App\Controllers\App::imageWithAlt($section['image']);
                $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
              @endphp
              @if(isset($img))
                @if($img_type == "svg")
                  @php
                    echo file_get_contents($img['image'])
                  @endphp
                @else
                  <img class="spec-width-532" src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}" srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                @endif
              @endif
            </div>
          </div>
        </div>
      </div>
@endif
@php $counter++; @endphp
@endforeach
</section>