{{--
Title: Delivery Date & Time
Description: Delivery Date & Time
Category: help_center_blocks
Icon: admin-comments
Keywords: delivery date time
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/delivery.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  $block_id_check = \App\Controllers\App::sg_get_first_block_id();
  echo $inline_style;
   $rating_shortcode = get_field('rating_shortcode');
@endphp
<section class="col-12" data-{{ $block['id'] }}>
  @if ($block['id'] === $block_id_check)
  <h1 class="mb-4 h2">{!! $title !!}</h1>
  @else
  <h3 class="mb-4 text-normal">{!! $title !!}</h3> 
  @endif
      <div class="mb-4 body-copy-b ">{!! $body_copy !!}</div>
      @if(have_rows('delivery'))
      @while(have_rows('delivery'))
      <div class="box-icon-text has-border">
          @php the_row();
          $box = get_sub_field('icon');
          @endphp
          @php
            if(!empty($box)){
            $icon =  \App\Controllers\App::imageWithAlt(get_sub_field('icon'));
            $icon_type =  \App\Controllers\App::checkImgExtension($box['filename']);
            }
          @endphp
          <div class="d-flex align-items-center mb-3 mb-lg-0">
            @if(isset($icon))
            <span class="box-icon p-absolute mr-3 mr-lg-0">
              @if($icon_type == "svg")
                @php
                  echo file_get_contents($icon['image'])
                @endphp
              @else
                <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}" srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
              @endif
            </span>
            @endif
            <h3 class="h5 bold-desc mb-0 mb-lg-3">{!! get_sub_field('title') !!}</h3>
          </div>
            <div class=body-copy-b ">{!! get_sub_field('body_copy') !!}</div>
        </div>
        @endwhile
      @endif

      @if(have_rows('text_sections'))
        @while(have_rows('text_sections'))
          @php the_row() @endphp
          <div class="colored-box notification-box mb-3 body-copy-b ">
            {!! get_sub_field('body_copy') !!}
          </div>
        @endwhile
      @endif
  <div>
    @php echo do_shortcode($rating_shortcode); @endphp
  </div>
</section>
