{{--
Title: FAQ and CTA Module
Description: FAQ and CTA Module
Category: montway_blocks
Icon: admin-comments
Keywords: faq cta
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/faq-cta.png
--}}
@php
$faq_group = get_field("faq_group");
$cta_group = get_field("cta_group");
$padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }}  class="faq-cta bg-white">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-6 pr-lg-5 py-80">
        <h2 class="mb-4">{!! $faq_group['title'] !!}</h2>
        <div class="accordions-wrap mb-4 mb-lg-0">

          @foreach($faq_group['questions'] as $question)
          <div class="accordion-item ">

            <h3 class="h5 my-1 js-accordion-trigger d-flex align-items-center" ><span class="d-inline-block faq-acc-title">{!! $question['title'] !!}</span> <i class="icon icon-keyboard_arrow_right"></i></h3>
            <div class="text-body body-link">{!! $question['question_body'] !!}</div>

          </div>
          @endforeach
        </div>
      </div>

      <div class="col-lg-6">
        @php
          $button = $cta_group['button'];
          $background_img = \App\Controllers\App::imageWithAlt($cta_group['background_image']);
          $background_type = \App\Controllers\App::checkImgExtension($cta_group['background_image']['filename']);
        @endphp
          <div class="text-wrap">
            <h2 class="h3 text-white faq-cta-title mb-3">{!! $cta_group['title'] !!}</h2>
            <div class="body-wrap mb-3 body-link">
              {!! $cta_group['body_copy'] !!}
            </div>
            @if(!empty($button['button_link']))
            <a href="{!! $button['button_link'] !!}" class="button-primary">{!! $button['button_text'] !!}</a>
            @endif
          </div>
        <div class="bg-wrap">
            @if(isset($background_img))

          <div class="img-wrap" style=" background-image: url({!! $background_img['image'] !!});">
          </div>

            @endif
        </div>
      </div>

    </div>
  </div>
</section>
