{{--
  Title: FAQ accordion on the left and image on the right
  Description:FAQ accordion on the left and image on the right
  Category: montway_blocks
  Icon: admin-comments
  Keywords: faq accordion questions answers
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/faq-accordion-left-image-right.png
--}}
@php
$title = get_field("title");
$img = get_field("image");
$questions = get_field("questions");
if(!empty($img)){
	$image = \App\Controllers\App::imageWithAlt($img);
	$image_type = \App\Controllers\App::checkImgExtension($img['filename']);
}

$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;

@endphp
<section data-{{ $block['id'] }} class="bg-white faq-with-image">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        @if ( is_page('help-center') )
          <h1 class="mb-4 h2">{!! $title !!}</h1>  
        @else
          <h2 class="mb-4">{!! $title !!}</h2>
        @endif
        <div class="accordions-wrap mb-4 mb-lg-0">
          @foreach($questions as $question)
            <div class="accordion-item ">
              <h3 class="h5 my-1 js-accordion-trigger">{!! $question['question'] !!} <i
                  class="icon icon-keyboard_arrow_right"></i></h3>
              <div class="text-body body-link">{!! $question['answer'] !!}</div>
            </div>
          @endforeach
        </div>
      </div>
      <div class="col-lg-5 offset-lg-1">
        <div class="img-wrap">
          @if(isset($image))
            @if($image_type == "svg")
              @php
                echo file_get_contents($image['image'])
              @endphp
            @else
              <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
            @endif
          @endif
        </div>
      </div>

      </div>
      </div>

</section>
