{{--
  Title: 4x4 images and copies module
  Description: 4x4 images and copies module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/4x4-images-copies.png
--}}
@php
$title = get_field("title");
$body_copy = get_field("body_copy");
$sections = get_field("single_section");
$padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-white industries">
  <div class="container">
    <div class="row">
      <div class="col-12">
          @if(!empty($title))
          <h2 class="mb-4">{!! $title !!}</h2>
          @endif

          @if(!empty($body_copy))
            <div class="mb-4 mb-lg-5 body-link">  {!! $body_copy !!}</div>
          @endif
      </div>

    @foreach($sections as $section)
      <div class="col-lg-6 mb-4 mb-lg-5">
          <div class="img-wrap">
            @php
              if(!empty($section['image'])){
              $img = \App\Controllers\App::imageWithAlt($section['image']);
              $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
              }
            @endphp
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}" srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif
          </div>
        <div>

            @if(!empty($section['title']))
                <h3 class="h3-heading">{!! $section['title'] !!}</h3>
            @endif
            @if(!empty($section['body_copy']))
                <div class="mb-3 body-link">{!! $section['body_copy'] !!}</div>
            @endif

            @if(!empty($section['button']['button_text'] && $section['button']['button_url']))
              <a href="{!! $section['button']['button_url'] !!}" class="is-underline">{!! $section['button']['button_text'] !!}</a>
            @endif
        </div>
      </div>
    @endforeach
    </div>
  </div>
</section>
