{{--
Title: Help Center Category Listing
Description: Help Center Category Listing
Category: montway_blocks
Icon: admin-comments
Keywords: help center categories
Mode: edit
Align: center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/hc-category-listing.png
--}}
@php
$title = get_field('title');
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="category-listing bg-gray-white">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>

    @if(have_rows('categories'))
    <div class=" col-lg-12">
      <div class="grid-wrap">
        @while(have_rows('categories'))
        <div class="box-icon-text">


          @php the_row();
          $cat = get_sub_field('select_help_center_category');
          $cat_name = get_term('name', 'helpcenter-category');
          $selected_posts = get_sub_field('select_category_posts');
          $term = get_term( $cat );
          $box = get_sub_field('icon');
          $posts = \App\Controllers\App::returnPostsfromHC($cat, 5, $selected_posts);

          if($box){
          $icon =  \App\Controllers\App::imageWithAlt(get_sub_field('icon'));
          $icon_type =  \App\Controllers\App::checkImgExtension($box['filename']);
          }
          @endphp
          <div class="d-flex align-items-center justify-content-between mb-3 mb-lg-0">
            <div class="d-flex flex-lg-column align-items-center align-items-lg-start">
            @if(isset($icon))
              @if($icon_type == "svg")
                <span class="icon-montway mr-3 mr-lg-0 mb-0 mb-lg-3">
                @php
                  echo file_get_contents($icon['image'])
                @endphp
                  </span>
              @else
                <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}" srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}">
              @endif
            @endif

          <div class="category ">
            <a class="text-blue h4 mb-lg-3 d-block" href="{!! get_term_link($term->slug, 'helpcenter-category') !!}">{!! $term->name !!}</a>
          </div>
        </div>
          <i class="icon-arrow_forward icon icon-grey"></i>
        </div>
          <ul>
            @foreach($posts['permalink'] as $key => $post)
            <li>
              <a class="text-caption text-hover-blue" href="{!! $post !!}">{!! $posts['title'][$key] !!}</a>
            </li>
            @endforeach
          </ul>
        </div>
        @endwhile
      </div>
      </div>
    @endif
  </div>
</div>
</section>
