{{--
Title: Help Center Accordion
Description: Help Center Accordion
Category: help_center_blocks
Icon: admin-comments
Keywords: help center categories
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/accordion-HC.png
--}}
@php
  if(isset($page_id)){
     $padding = get_field("block_padding", $page_id);
      if(!isset($block['id'])){
    	  $block['id'] = 'hfgdguiiooi';
        }
     $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
     echo $inline_style;
     }
     $categories = get_the_terms( $post->ID, 'helpcenter-category' );
     $category_name = $categories[0]->slug;
@endphp
<div class=" {!! ( !is_singular( 'help-center' ) ) ? 'col-lg-4' : 'mb-80' !!}" data-{{ $block['id'] }} >
  <div class="accordions-wrap sidebar no-open">
        @php
          $cat = get_field('help_center_categories', $page_id);
          foreach ($cat as $key => $single_cat){


          	$term = get_term( $single_cat );
          	if($term){
            $posts = \App\Controllers\App::returnPostsfromHC($single_cat, -1);
    $image = get_field('icon_taxonomy', $term->taxonomy . '_' . $term->term_id);

        @endphp
        <div class="box-sidebar box-icon-text accordion-item mb-3 mb-lg-0 {!! ( $category_name == $term->slug ) ? 'is-open' : '' !!}">
          <div class="d-flex align-items-center justify-content-between label-wrap mb-lg-3 pb-lg-2 js-accordion-trigger">
            <div class="d-flex align-items-center">
            @if(!empty($image))
              <span class="icon-wrap d-inline-block d-lg-none mr-3">
              <img src="{!! $image !!}" />
            </span>
            @endif
            <span class="h5  d-block bold-desc">{!! $term->name !!}</span>
          </div>
            <i class="icon icon-keyboard_arrow_right"></i>
          </div>
          <ul class="text-wrap">
            @foreach($posts['permalink'] as $key => $post)
            <li>
              <a  class="text-hover-blue text-gray" href="{!! $post !!}">{!! $posts['title'][$key] !!}</a>
            </li>
            @endforeach
          </ul>
        </div>

        @php
          }
           }
        @endphp
  </div>
</div>
