{{--
Title: List without bullets
Description: List without bullets
Category: help_center_blocks
Icon: admin-comments
Keywords: list
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/list-without-bullets.png
--}}
@php
  $title= get_field('title');
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $rating_shortcode = get_field('rating_shortcode');
@endphp
<section class="without-bullets mb-3" data-{{ $block['id'] }} >
  <h2 class="mb-3 mb-lg-4">{!! $title !!}</h2>
  @if(have_rows('list'))
    @while(have_rows('list'))
      @php the_row(); @endphp
      <h3 class="p ml-3">{!! get_sub_field('list_title') !!}</h3>
      @if(have_rows('list_elements'))
        <ul>
          @while(have_rows('list_elements'))
            @php the_row(); @endphp
            <li>{!! get_sub_field('single_element') !!}</li>
          @endwhile
        </ul>
      @endif
    @endwhile
  @endif
</section>
<div>
  @php echo do_shortcode($rating_shortcode); @endphp
</div>
