{{--
Title: Help Center Procedure
Description: Help Center Procedure
Category: help_center_blocks
Icon: admin-comments
Keywords: procedure
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/procedure.png
--}}
@php
$title = get_field('title');
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
$i = 1;
@endphp

<section class="col-12"  data-{{ $block['id'] }}>
    <h3 class="text-normal mb-4">{!! $title !!}</h3>
    @if(have_rows('pickup'))
      @while(have_rows('pickup'))
        @php the_row() @endphp
        <div class="row">
          <div class="col-lg-5 ">
            <h3 class="pb-4 pb-lg-5 text-normal">{!! get_sub_field('pickup_title') !!}</h3>
          </div>
          <div class="col-middle col-lg-2 d-none d-lg-inline-flex">
            <span></span>
          </div>
          <div class="col-lg-5 ">
            @php
              $delivery_title = get_sub_field('delivery_title');
            @endphp
            <h3 class="pb-4 pb-lg-5 text-normal d-none d-lg-block">{!! $delivery_title !!}</h3>
          </div>
        </div>
        <div class="d-none d-lg-block">
          @if(have_rows('pickup_group'))
            @while(have_rows('pickup_group'))
              @php the_row() @endphp
              <div class="procedure-wrap d-flex flex-column flex-lg-row row">
                <div class="col-lg-5 ">
                  <div class="mb-4 body-copy-b ">{!! get_sub_field('body_copy_pickup') !!}</div>
                </div>
                <div class="col-middle col-lg-2 d-none d-lg-inline-flex">
                <span class="middle-line"><span class="number">{!! file_get_contents(home_url() . '/app/themes/montway/resources/assets/images/procedure-'. $i .'.svg' ) !!}</span></span>
                </div>
                <div class="col-lg-5 ">
                  <div class="mb-4 body-copy-b ">{!! get_sub_field('body_copy_delivery') !!}</div>
                </div>
              </div>
              @php
                  $i++;
              @endphp
            @endwhile
          @endif
        </div>
        <div class="d-block d-lg-none">
          @if(have_rows('pickup_group'))
            @while(have_rows('pickup_group'))
              @php the_row() @endphp
              <div class="procedure-wrap d-flex flex-column flex-lg-row row">
                <div class="col-lg-5 ">
                  <div class="mb-4 body-copy-b ">{!! get_sub_field('body_copy_pickup') !!}</div>
                </div>
              </div>
            @endwhile
          @endif
          <h3 class="pb-4 pb-lg-5 text-normal d-block d-lg-none">{!! $delivery_title !!}</h3>
          @if(have_rows('pickup_group'))
            @while(have_rows('pickup_group'))
              @php the_row() @endphp
              <div class="procedure-wrap d-flex flex-column flex-lg-row row">
                <div class="col-lg-5 ">
                  <div class="mb-4 body-copy-b ">{!! get_sub_field('body_copy_delivery') !!}</div>
                </div>
              </div>
            @endwhile
          @endif
        </div>
      @endwhile
    @endif
</section>
