{{--
  Title: Image, text and button module V2
  Description: Image, text and button module V2
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text image button
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-text-button.png
--}}
@php
  $title = get_field('title');
  $subtitle = get_field('subtitle');
  $body_copy = get_field('list');
  $img = get_field('image');
  if(!empty($img)){
  $image = \App\Controllers\App::imageWithAlt($img);
  $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
  }
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  /*$button = get_field('button');
  $button_type = get_field('button_type');*/
@endphp
<section data-{{ $block['id'] }} class="img-text-button">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
    </div>
    <div class="row align-items-center  ">
      <div class="col-lg-5 mb-3 mb-lg-0">
        <div>
          <h2 class="h2 mb-4 ">{!! $subtitle !!}</h2>
          <div class="body-link">{!! $body_copy !!}</div>
          {{--@if($button_type == 'shortcode')
            @if($button['button_link'])
              <button class="button-primary mt-2">{!! $button['button_text'] !!}</button>
              @php //gravity_form( get_field('contact_form_shordcode'), false, false, false, null, true ); @endphp
            @endif
          @else
            <a href="{!! $button['button_link'] !!}" class="button-primary mt-2">{!! $button['button_text'] !!}</a>
          @endif--}}
        </div>
      </div>
      <div class="col-lg-7">
        @if($image_type == "svg")
          @php
            echo file_get_contents($image['image'])
          @endphp
        @else
          <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
               srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
        @endif
      </div>
    </div>
  </div>
</section>
