{{--
  Title: Text and Image Module (Hawaii)
  Description: Text and Image Module (Hawaii)
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text image hawaii
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: false
  Preview: true
  PreviewImage: /resources/assets/block-images/text-image-hawaii.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="image-text-hawaii list-style-blue">
  <div class="container">
    @php
      $rowCount = 0;
    @endphp
    @if(have_rows('section'))
      @while(have_rows('section'))
        @php
          the_row();
          $title = get_sub_field('title');
          $subtitle = get_sub_field('subtitle');
          $button = get_sub_field('button');
          $body_copy = get_sub_field('body_copy');
          if(!empty(get_sub_field('image'))){
          $image = get_sub_field('image');
          $img = \App\Controllers\App::imageWithAlt($image);
          $img_type = \App\Controllers\App::checkImgExtension($image['filename']);
          }
        @endphp
        @if($rowCount++ % 2 == 1)
          <div class="row mb-80">
            <div class="col-lg-5">
              <div class="img-wrap">
                @if(isset($img))
                  @if($img_type == "svg")
                    @php
                      echo file_get_contents($img['image'])
                    @endphp
                  @else
                    <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                      srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}" />
                  @endif
                @endif
              </div>
            </div>
            <div class="col-lg-7 pl-lg-5 mb-4 mb-lg-0">
              <div class="mb-4">
                <h2 class="">{!! $title !!}</h2>
                <h3 class="h5 bold-desc">{!! $subtitle !!}</h3>
              </div>
              <div class="text-gray body-link">{!! $body_copy !!}</div>
              @if(!empty($button['button_link']))
                <a href="{!! $button['button_link'] !!}" class="button-primary mt-32">{!! $button['button_text'] !!}</a>
              @endif
            </div>
          </div>
        @else
          <div class="row mb-80">
            <div class="col-lg-7 pr-lg-5 order-2 order-lg-1 mb-4 mb-lg-0">
              <div class="mb-4">
                <h2 class="">{!! $title !!}</h2>
                <h3 class="h5 bold-desc">{!! $subtitle !!}</h3>
              </div>
              <div class="text-gray body-link">{!! $body_copy !!}</div>
              @if(!empty($button['button_link']))
                <a href="{!! $button['button_link'] !!}" class="button-primary mt-32">{!! $button['button_text'] !!}</a>
              @endif
            </div>
            <div class="col-lg-5 order-1 order-lg-2">
              <div class="img-wrap ">
                @if(isset($img))
                  @if($img_type == "svg")
                    @php
                      echo file_get_contents($img['image'])
                    @endphp
                  @else
                    <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                      srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}" />
                  @endif
                @endif
              </div>
            </div>
          </div>
        @endif
      @endwhile
    @endif
  </div>
</section>
