{{--
  Title: Image and Text V2 Module
  Description: Image and Text V2 Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-text-v2.png
--}}
@php
  $title = get_field("title");
  $subtitle = get_field("subtitle");
  $sections = get_field("section");
  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-white text-img-v2 list-style-blue">
  <div class="container">

    @php
      $rowCount = 0;
    @endphp
    @foreach($sections as $section)
      @if($rowCount++ % 2 == 1)
        <div class="row mb-4 mb-md-5 pb-lg-5 align-items-center">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp

          <div class="col-md-6   ">
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                     srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif
          </div>
          <div class="col-md-6   mb-3 mb-md-0 ">
            <h2 class="h2 mb-3 mb-lg-4">{!! $section['title'] !!}</h2>
            <div class="body-link">{!! $section['body_copy'] !!}</div>
          </div>
        </div>
      @else
        <div class="row mb-4 mb-md-5 pb-lg-5  align-items-center">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp
          <div class="col-md-6 mb-3 mb-md-0 order-2">
            <h2 class="h2 mb-3 mb-lg-4">{!! $section['title'] !!}</h2>
            <div class="body-link">{!! $section['body_copy'] !!}</div>
          </div>
          <div class="col-md-6  order-1 order-md-2">
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                     srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif

          </div>

        </div>
      @endif
    @endforeach
  </div>
</section>
