{{--
  Title: Image and Text V4 Module
  Description: Image and Text V4 Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-text-v4.png
--}}
@php
  $title = get_field("title");
  $sections = get_field("section");
   $padding = get_field("block_padding");
   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
   echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-white text-img-v4 bg-mob-light">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if(!empty($title))
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        @endif
      </div>
    </div>
    @php
      $rowCount = 0;
    @endphp
    @foreach($sections as $section)
      @if($rowCount++ % 2 !== 1)
        <div class="row mb-4 mb-md-5 pb-lg-5 ">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp

          <div class="col-md-6 col-lg-5 order-2 ">
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                  srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif
          </div>
          <div class="col-md-6 col-lg-5  offset-lg-1 order-1 mb-3 mb-md-0 order-md-2 js-parent-container-open">
            <div class="js-container-toggle">
              @if(!empty($section['title']))
              <h2 class="h2 mb-3 mb-lg-4">{!! $section['title'] !!}</h2>
              @endif
              <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
              <div class="item-hidden text-gray body-link">{!! $section['body_copy_hidden'] !!}</div>
              @if($section['body_copy_hidden'])
                <button data-text-open="Read less" data-text-close="Read more"
                  class="is-underline p-0 js-button-trigger js-see-more-button mt-3"><span class="js-button-text">Read
                    more</span></button>
              @endif
            </div>
          </div>
        </div>
      @else
        <div class="row mb-4 mb-md-5 pb-lg-5  ">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp
          <div class="col-md-6 col-lg-5 js-parent-container-open  mb-3 mb-md-0">
            <div class="js-container-toggle">
              @if(!empty($section['title']))
              <h2 class="h2 mb-3 mb-lg-4">{!! $section['title'] !!}</h2>
              @endif
              <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
              <div class="item-hidden body-link">{!! $section['body_copy_hidden'] !!}</div>
              @if($section['body_copy_hidden'])
                <button data-text-open="Read less" data-text-close="Read more"
                  class="is-underline p-0 js-button-trigger js-see-more-button mt-3"><span class="js-button-text">Read
                    more</span></button>
              @endif
            </div>
          </div>
          <div class="col-md-6 col-lg-5 offset-lg-2 ">
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                  srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif

          </div>

        </div>
      @endif
    @endforeach
  </div>
</section>
