{{--
Title: A list on the left & graph on the right
Description: A list on the left & graph on the right
Category: montway_blocks
Icon: admin-comments
Keywords: list text graph
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/list-left-graph-right.png
--}}
@php
$title = get_field("title");
$right_title = get_field('right_title');
$graph = get_field("graph");
if(!empty($graph)){
	$graph_img = \App\Controllers\App::imageWithAlt($graph);
	$graph_type = \App\Controllers\App::checkImgExtension($graph['filename']);
}
$list = get_field("list");
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
@endphp
<section class="bg-gray list-graph">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-6 order-2 order-lg-1" data-{{ $block['id'] }}>

        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        <div class="list-wrap">
        @foreach($list as $item)
          <div class="box-icon-text has-border js-container-toggle">
            <div class="d-flex align-items-center justify-content-between">
              <div class="d-flex align-items-center">
                @if(!empty($item['icon']))
                  @php
                    $icon = \App\Controllers\App::imageWithAlt($item['icon']);
                    $icon_type = \App\Controllers\App::checkImgExtension($item['icon']['filename']);
                  @endphp
                  @if(!empty($icon))
                    @if($icon_type == "svg")
                      <span class="box-icon p-absolute">
                        @php
                          echo file_get_contents($icon['image'])
                        @endphp
                      </span>
                    @else
                      <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}"
                        srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}" alt="">
                    @endif
                  @endif
                @endif
                <h3 class="h5 bold-desc mb-0 mb-lg-2">{!! $item['headline'] !!}</h3>
              </div>
              <i class="icon icon-keyboard_arrow_right"></i>

            </div>
            <div class="text-wrap text-gray mt-0">{!! $item['body_copy'] !!}</div>

          </div>
        @endforeach
      </div>
      </div>
      <div class="col-lg-6 order-1 order-lg-2">
        <div class="right-wrap">

          <h2 class="h3 graph-title  mb-4">{!! $right_title !!}</h2>
          <div class="graph-wrap">
            @if(!empty($graph_img))
            @if($graph_type == "svg")
            @php
                echo file_get_contents($graph_img['image'])
                @endphp
            @else
            <img src="{!! $graph_img['image'] !!}" alt="{!! $graph_img['alt'] !!}"
            srcset="{!! $graph_img['small'] . $graph_img['medium'] . $graph_img['large'] !!}" alt="">
            @endif
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
