{{--
Title: Logo Slider
Description: Logos
Category: montway_blocks
Icon: admin-comments
Keywords: logo logos slider
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/logos.png
--}}
@php
  $title = get_field("title");
  $logos = get_field("logos");
  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="logos-section logos-slider position-relative bg-white">
  <div class="container">
    <div class="row">
      @if ( !empty( $title ) )
        <div class="col-12">
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        </div>
      @endif
      <div class="col-12">
        <div class="logos-wrap d-lg-flex align-items-center justify-content-between swiper-container logos-swiper">
          <div class="swiper-wrapper">
            @foreach($logos as $logo)
              <div class="swiper-slide">
                <div class="logo">
                  @if($logo['link'])
                    <a href="{!! $logo['link'] !!}">
                  @endif
                  @php
                    if(!empty($logo['logo_image'])){
                    $img = \App\Controllers\App::imageWithAlt($logo['logo_image']);
                    $img_type = \App\Controllers\App::checkImgExtension($logo['logo_image']['filename']);
                    }
                  @endphp
                  @if(isset($img))
                    @if($img_type == "svg")
                      @php
                        echo file_get_contents($img['image'])
                      @endphp
                    @else
                      <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                    @endif
                  @endif

                  @if($logo['link'])
                    </a>
                  @endif
                </div>
              </div>
            @endforeach
          </div>
          <div class="swiper-pagination logos-pagination"></div>
        </div>
      </div>
        <div class="swiper-button-prev logos-prev {{ ( empty( $title ) ) ? 'top-half' : '' }}"></div>
        <div class="swiper-button-next logos-next {{ ( empty( $title ) ) ? 'top-half' : '' }}"></div>
    </div>
  </div>
</section>
