{{--
  Title: Map with Text
  Description: Map with Text
  Category: montway_blocks
  Icon: admin-comments
  Keywords: map
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/map-on-click.png
--}}
@php
  $title = get_field('map_title', 'option');
  $body_copy = get_field('body_copy', 'option');
  $body_copy_hidden = get_field('body_copy_hidden', 'option');
  $shortcode = get_field('map_shortcode', 'option');
@endphp
<section>
  <div class="container">
    <div class="row">
      <div class="col-12 js-parent-container-open">
        <div class="js-container-toggle">
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
          <div class="text-gray">
            {!! $body_copy !!}
          </div>
          <div class="text-gray pt-4 item-hidden">
            {!! $body_copy_hidden !!}
            <div class="mt-5">{!! $shortcode !!}</div>
          </div>
          <button data-text-open="Read less" data-text-close="Read more"
            class="is-underline p-0 js-button-trigger js-see-more-button mt-4">
            <span class="js-button-text">Read more</span></button>
        </div>
      </div>
    </div>
  </div>
</section>
