{{--
Title: One Big Review
Description: One Big Review
Category: montway_blocks
Icon: admin-comments
Keywords: reviews
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/big-number.png
--}}
@php
  $title = get_field("title");
  $subheadline = get_field("subheadline");
  $small_headline = get_field("small_headline");
  $blocks = get_field("blocks");
  $rating = get_field("rating");
  $rating_num = number_format((float)$rating, 1, '.', '');
  $title_under_rating = get_field("title_under_rating");
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="review-single-large">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h1 class="mb-4">{!! $title !!}</h1>
        <h2 class="h5 bold-desc mb-4">{!! $subheadline !!}</h2>
      </div>
      <div class="col-lg-11 col-xl-9 mx-auto">
        <div class="review-box-shadow d-flex row mx-2 mx-md-0">
          <div class="col-12">
              <h3 class="d-block mb-5 text-gray bold-desc h5">{!! $small_headline !!}</h3>

            </div>
          <div class="col-lg-5 order-2 order-lg-1">
            <div class="review-grid">
              @foreach($blocks as $block)
                <div class="review-block d-flex flex-column align-items-center d-lg-block">
                  @php
                    if(!empty($block['icon'])){
                    $image = \App\Controllers\App::imageWithAlt($block['icon']);
                    $image_type = \App\Controllers\App::checkImgExtension($block['icon']['filename']);
                    }
                  @endphp
                  @if(!empty($image))
                    @if($image_type == "svg")
                      <span class="icon-montway mb-2">
                        @php
                          echo file_get_contents($image['image'])
                        @endphp
                      </span>
                    @else
                      <img class="icon-montway mb-2" src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                        srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                    @endif
                  @endif
                  <p class="h5 bold-desc">{!! $block['shortcodes'] !!}</p>
                  <p class="text-gray-medium text-center text-md-left text-caption">{!! $block['body_copy'] !!}</p>
                </div>
              @endforeach
            </div>
          </div>

          <div class="col-lg-7 mb-4 mb-lg-0 order-1 order-lg-2 large-review d-flex align-items-start justify-content-center justify-content-lg-end">
            <div class="d-flex flex-column align-items-center">
              <span class="rating-number-large bold">{!! $rating_num !!}</span>
              @php
                $stars = \App\Controllers\App::startRating($rating);
              @endphp
              <div class="d-flex stars-wrap mb-2">

                @for($i=0; $i<$stars['full']; $i++)
                  <img src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                @endfor
                @if(isset($stars['half']))
                  <img src={!! get_template_directory_uri() . '/assets/images/review-page-' .$stars['half'].'.png'
                    !!} />
                @endif
              </div>
              <span class="text-caption text-center text-gray-medium">{!! $title_under_rating !!}</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
