{{--
  Title: Interactive progress bar
  Description: Interactive progress bar
  Category: montway_blocks
  Icon: admin-comments
  Keywords: progress bar
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/interactive-progress-bar.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $steps = get_field("steps");
@endphp
@php
$rowCount = 0;
@endphp
<section data-{{ $block['id'] }} class="progress-bar-section bg-light">
  <div class="container">
    <div class="row">
      <div class="col-12 z-index-2">
        <div class="d-flex justify-content-between">
          @foreach($steps as $step)
            @php
              if(!empty($step['icon'])){
              $img = \App\Controllers\App::imageWithAlt($step['icon']);
              $img_type = \App\Controllers\App::checkImgExtension($step['icon']['filename']);
              }

              $rowCount ++;
            @endphp
            <a href="#section_{!! $rowCount !!}"
              class="d-flex flex-column align-items-center text-center justify-content-center step-wrap">
              <span class="text-blue bold h4">{!! $step['label'] !!}</span>
              <p class="h4 bold mb-3">{!! $step['title'] !!}</p>
              @if(isset($img))
                @if($img_type == "svg")
                  <span class="icon">
                    @php
                      echo file_get_contents($img['image'])
                    @endphp
                  </span>
                @else
                  <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                @endif
              @endif
            </a>
          @endforeach
        </div>

      </div>
      <div class="col-12 z-index-1">
        <div class="arrows-strip-wrap">
          <div class="arrows-strip"></div>
          <div class="arrow-effect"></div>
        </div>
      </div>
    </div>
  </div>
  <div class="background-bar"></div>

</section>
