{{--
  Title: Reviews Module
  Description: Reviews Module in one line
  Category: montway_blocks
  Icon: admin-comments
  Keywords: reviews
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/reviews.png
--}}
@php
  $reviews = get_field("select_reviews");

  if(!empty($reviews)){
  $display_reviews = \App\Controllers\App::getReviews($reviews);
  }else{
  $display_reviews = \App\Controllers\App::getReviews();
  }

  $title = get_field("title");
  $slider_type = get_field("display_type");
  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class=" position-relative bg-white">
  <div class="container">

    <div class="row">
      <div class="col-12">
        <h4 class="h4 mb-3">{!! $title !!}</h4>
      </div>
      @if($slider_type == "three_line")
        <div class="col-12 swiper-container reviews-swiper-three-cards">
          <div class="swiper-wrapper">
            @foreach($display_reviews as $key => $review)
              <div class="swiper-slide review3-box-width mr-20">
                <div class="review-box">
                  <div>
                    <div class="name-rating-wrap">
                      <span class="h4 text-caption text-gray-medium">{!! $review['name'][0] !!}</span>
                      @php
                        $stars = \App\Controllers\App::startRating($review['rating'][0]);
                      @endphp
                      <div class="stars-wrapper">
                        @for($i=0; $i<$stars['full']; $i++)
                          <img class="no-lazy" src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                        @endfor
                        @if(isset($stars['half']))
                          <img class="no-lazy" src={!! get_template_directory_uri() . '/assets/images/review-page-'
                            .$stars['half'].'.png' !!} />
                        @endif
                      </div>
                      @php
                        $rating = number_format((float)$review['rating'][0], 1, '.', '');
                        @endphp
                      <span class="rating">{!! $rating !!}</span>
                    </div>
                    <div class="review-body">
                      <p>{!! $review['review'][0] !!}</p>
                    </div>
                  </div>
                  <div class="date-wrap">
                    <span class="text-gray-medium text-small">{!! $review['date'][0] !!}</span>
                    @php
                      $review_logo_type = \App\Controllers\App::checkImgExtension($review['logo'][0]['image']);
                    @endphp
                    @if($review_logo_type == "svg")
                      @php
                        echo file_get_contents($review['logo'][0]['image'])
                      @endphp
                    @else
                      <div class="img-wrap"> 
                        <img class="no-lazy" src="{!! $review['logo'][0]['image'] !!}" alt="{!! $review['logo'][0]['alt'] !!}"
                          srcset="{!! $review['logo'][0]['small'] . $review['logo'][0]['medium'] . $review['logo'][0]['large'] !!}">
                      </div>
                    @endif
                  </div>

                </div>
              </div>
            @endforeach
          </div>
          <div class="swiper-pagination reviews-pagination"></div>
        </div>
        <div class="swiper-button-prev review-prev"></div>
        <div class="swiper-button-next review-next"></div>
      @else
        <!-- Two reviews per slide -->
        <div class="col-12 swiper-container reviews-swiper">
          <div class="swiper-wrapper">
            @foreach($display_reviews as $key => $review)
              <div class="swiper-slide review2-box-width mr-20">
                <div class="review-box">
                  <div>
                    <div class="name-rating-wrap">
                      <span class="h4 text-caption text-gray-medium">{!! $review['name'][0] !!}</span>
                      @php
                        $stars = \App\Controllers\App::startRating($review['rating'][0]);
                      @endphp
                      <div class="stars-wrapper">
                        @for($i=0; $i<$stars['full']; $i++)
                          <img class="no-lazy" src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                        @endfor
                        @if(isset($stars['half']))
                          <img class="no-lazy" src={!! get_template_directory_uri() . '/assets/images/review-page-'
                            .$stars['half'].'.png' !!} />
                        @endif
                      </div>
                      @php
                        $rating = number_format((float)$review['rating'][0], 1, '.', '');
                      @endphp
                      <span class="rating">{!! $rating !!}</span>
                    </div>
                    <div class="review-body">
                      <p>{!! $review['review'][0] !!}</p>
                    </div>
                  </div>
                  <div class="date-wrap">
                    <span class="text-gray-medium text-small">{!! $review['date'][0] !!}</span>
                    @php
                      $review_logo_type = \App\Controllers\App::checkImgExtension($review['logo'][0]['image']);
                    @endphp
                    @if($review_logo_type == "svg")
                      @php
                        echo file_get_contents($review['logo'][0]['image'])
                      @endphp
                    @else
                      <div class="img-wrap">
                        <img class="no-lazy"  src="{!! $review['logo'][0]['image'] !!}" alt="{!! $review['logo'][0]['alt'] !!}"
                          srcset="{!! $review['logo'][0]['small'] . $review['logo'][0]['medium'] . $review['logo'][0]['large'] !!}">
                      </div>
                    @endif
                  </div>

                </div>
              </div>
            @endforeach
          </div>
          <div class="swiper-pagination reviews-pagination"></div>
        </div>
        <div class="swiper-button-prev review-prev"></div>
        <div class="swiper-button-next review-next"></div>
      @endif
    </div>
  </div>
</section>
