{{--
  Title: Simple Steps
  Description: Simple Steps
  Category: montway_blocks
  Icon: admin-comments
  Keywords: step steps
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/simple-steps.png
--}}
@php
  $title = get_field("title");
  $sections = get_field("steps");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="progress-bar-tabs three-steps bg-white">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if(!empty($title))
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        @endif
      </div>
    </div>
    <div class="steps-hawaii row mx-lg-5">
      @foreach($sections as $section)
        <div class="col-lg-4">
          <div class="single-step js-parent-container-open">
            <div class="d-flex flex-column align-items-center js-container-toggle">
              @php
                if(!empty($section['icon'])){
                $img = \App\Controllers\App::imageWithAlt($section['icon']);
                $img_type = \App\Controllers\App::checkImgExtension($section['icon']['filename']);
                }
              @endphp
              @if(isset($img))
                @if($img_type == "svg")
                  <span class="icon-montway">
                    @php
                      echo file_get_contents($img['image'])
                    @endphp
                  </span>
                @else
                  <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                    srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                @endif
              @endif
              <div class="d-flex flex-column align-items-center">
                <h2 class="step-number text-blue h4 bold">{!! $section['step'] !!}</h2>
                <p class="h6 bold">{!! $section['title'] !!}</p>
                <div class="text-wrap body-link">{!! $section['body_copy'] !!}</div>
                <div class="item-hidden body-link">{!! $section['body_copy_hidden'] !!}</div>
                @if($section['body_copy_hidden'])
                  <button data-text-open="Read less" data-text-close="Read more"
                    class="is-underline p-0 js-button-trigger js-see-more-button mt-3 mb-3 align-self-start align-self-lg-center">
                    <span class="js-button-text">Read more</span></button>
                @endif
              </div>
            </div>
          </div>
        </div>
      @endforeach
    </div>

  </div>
</section>
