{{--
  Title: Sitemap
  Description: Sitemap
  Category: montway_blocks
  Icon: admin-comments
  Keywords: sitemap
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/sitemap.png
--}}
@php
    $padding = get_field("block_padding");
    $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
    echo $inline_style;

@endphp
<section data-{{ $block['id'] }}>
  <div class="container">
    <div class="row">


      @if(have_rows('link_group'))
          @while(have_rows('link_group'))
              @php the_row();
                $section = get_sub_field('section');
              @endphp
              <div class="col-lg-4">
                <h2 class="mb-2">{!! get_sub_field('title') !!}</h2>
                <ul class="mb-3">

                  @foreach($section as $link)
                  <li class="mb-1">
                    <a href="{!!  $link['links']['url'] !!}" class="is-underline ">{!! $link['links']['title'] !!}</a>
                  </li>
                  @endforeach
                </ul>
              </div>
          @endwhile
      @endif
    </div>
  </div>
</section>
