{{--
Title: Table and boxes on the right
Description: Table and boxes on the right
Category: help_center_blocks
Icon: admin-comments
Keywords: table boxes
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/table-boxes.png
--}}
@php
$title = get_field('title');
$undertitle = get_field('undertitle');
$padding = get_field('block_padding');
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
@endphp
<section class="col-12 mb-3 table-boxes-block" data-{{ $block['id'] }} >
    <h2 class="mb-3 mb-lg-4">{!! $title !!}</h2>
    <h3 class="text-normal mb-4">{!! $undertitle !!}</h3>
    <div class="table-box-wrap d-flex flex-column flex-lg-row justify-content-between">
      <div class="w-100 mr-lg-5 mb-5 mb-lg-0">
          @if(have_rows('table'))
              @while(have_rows('table'))
                  @php the_row();
                  @endphp
             <table>
              <thead>
              <tr>
                @if(have_rows('table_head'))
                  @while(have_rows('table_head'))
                    @php the_row(); @endphp
                    <th>{!! get_sub_field('head_text') !!}</th>
                  @endwhile

                @endif
              </tr>
              </thead>
               <tbody>
                @if(have_rows('table_body'))
                  @while(have_rows('table_body'))
                      @php the_row(); @endphp
                      <tr>
                      <td>{!! get_sub_field('first_column') !!}</td>
                      <td>{!! get_sub_field('second_column') !!}</td>
                      </tr>
                  @endwhile
                @endif
               </tbody>
             </table>
                <span class="text-gray mt-3 d-block">{!! get_sub_field('estimate') !!}</span>
              @endwhile
          @endif
      </div>
      <div>
        @if(have_rows('group'))
            @while(have_rows('group'))
            <div class="box-icon-text has-border">
                @php the_row();
                  if(get_sub_field('icon')){
                      $img = get_sub_field('icon');
                      $image = \App\Controllers\App::imageWithAlt(get_sub_field('icon'));
                      $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
                    }
                @endphp

                <div class="d-flex align-items-center mb-3 mb-lg-0">
                @if(isset($image))
                <span class="box-icon p-absolute mr-3 mr-lg-0">
                  @if($image_type == "svg")
                    @php
                      echo file_get_contents($image['image'])
                    @endphp
                  @else
                    <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}" >
                  @endif
                </span>
                @endif
                <h4 class="h5 bold-desc mb-0 mb-lg-3">{!! get_sub_field('title') !!}</h4>
              </div>
                <div class="text-gray body-copy-b ">{!! get_sub_field('body_copy') !!}</div>
              </div>
            @endwhile
        @endif
      </div>
    </div>
</section>
