{{--
  Title: Blue table
  Description: Blue table
  Category: montway_blocks
  Icon: admin-comments
  Keywords: table
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/blue-table.png
--}}
@php
$title = get_field('title');
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
$i = 1;
@endphp
<section data-{{ $block['id'] }} class="blue-table">
  <div class="container">
    <div class="row">
      <h2 class="mb-5 mb-xl-1 col-12">{!! $title !!}</h2>
    </div>
  </div>
  <div class="bg-sky-blue position-relative">
    <div class="container">
      <div class="row table-row py-3 table-desktop">
        @if(have_rows('table'))
          @while(have_rows('table'))
            @php the_row(); 
              $image = \App\Controllers\App::imageWithAlt(get_sub_field('image'));
              $image_type = \App\Controllers\App::checkImgExtension(get_sub_field('image')['filename']);
            @endphp
            @if(isset($image))
              <div class="img-wrap col-lg-2  {{ ( $i > 1 ) ? 'col-half-offset pl-0' : '' }}">
              @if ( $image_type == "svg" )
                {!! file_get_contents($image['image']) !!}
              @else
                <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}">
              @endif
              </div>
            @endif
            @php
                $i++;
            @endphp
          @endwhile
        @endif
      </div>
      <div class="row table-row py-3 table-mobile swiper-container blue-table-swiper px-4 px-xl-0">
        <div class="swiper-wrapper align-items-center">
          @if(have_rows('table'))
            @while(have_rows('table'))
              @php the_row(); 
                $image = \App\Controllers\App::imageWithAlt(get_sub_field('image'));
                $image_type = \App\Controllers\App::checkImgExtension(get_sub_field('image')['filename']);
              @endphp
              @if(isset($image))
                <div class="swiper-slide img-wrap">
                @if ( $image_type == "svg" )
                  {!! file_get_contents($image['image']) !!}
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}">
                @endif
                </div>
              @endif
            @endwhile
          @endif
        </div>
      </div>
    </div>
    <div class="swiper-button-prev blue-tabel-prev"></div>
    <div class="swiper-button-next blue-table-next"></div>
  </div>
  <div class="swiper-pagination blue-table-pagination position-relative d-block d-md-none"></div>
</section>
