{{--
  Title: Text above and icon blocks
  Description:Text above and icon blocks
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text icons
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-above-icons.png
--}}
@php
  $paragraph = apply_filters( 'the_content', get_field('paragraph') );
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-gray-white">
  <div class="container">
    <div class="row">
      <div class="col-12 mb-5">
        <div>{!! $paragraph !!}</div>
      </div>

      @if(have_rows('icon_blocks'))
        @while(have_rows('icon_blocks'))
          @php
            the_row();
            $icon = get_sub_field('icon');
            if(!empty($icon)){
            $image = \App\Controllers\App::imageWithAlt($icon);
            $image_type = \App\Controllers\App::checkImgExtension($icon['filename']);
            }
            $title = get_sub_field('title');
            $body_copy = get_sub_field('body_copy');
          @endphp
          <div class="col-lg-4">
            <div class="box-icon-text">
              <div class="d-flex flex-row flex-lg-column align-items-center align-items-lg-start mb-2 mb-lg-0">
                @if(!empty($image))
                  @if($image_type == "svg")
                    <span class="d-block icon-montway icon-wrap mr-3 mb-lg-1">
                      @php
                        echo file_get_contents($image['image'])
                      @endphp
                    </span>
                  @else
                    <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                      srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                  @endif
                @endif
                <h3 class="h4 bold mb-lg-1">{!! $title !!}</h3>
              </div>
              <p class="text-gray">{!! $body_copy !!}</p>
            </div>
          </div>
        @endwhile
      @endif

    </div>
  </div>
</section>
