{{--
  Title: Text and Icon Block
  Description:Text and Icon Block
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text icons
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-icons.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $list = get_field('list');
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="text-icon-section">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>

      <div class="col-lg-6">
        <div class="body-link">{!! $body_copy !!}</div>
      </div>
      <div class="col-lg-6">
        <div class="grid-wrap">

        @foreach($list as $item)
        <div class="d-flex align-items-center text-icon-wrap">
          @php
            if(!empty($item['icon'])){
            $image = \App\Controllers\App::imageWithAlt($item['icon']);
            $image_type = \App\Controllers\App::checkImgExtension($item['icon']['filename']);
            }
          @endphp
          @if(!empty($image))
            @if($image_type == "svg")
            <span class="icon-wrap mr-3">
              @php
                echo file_get_contents($image['image'])
                @endphp
            </span>
            @else
              <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
            @endif
          @endif
          <h3 class="h5">{!! $item['text'] !!}</h3>
        </div>
        @endforeach

      </div>

      </div>
    </div>
  </div>
</section>
