{{--
  Title: Text and image on blue background
  Description: Text and image on blue background
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text cta
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-image-blue-bg.png
--}}
@php
  $text = get_field('text');
  $image = get_field('image');
  if(!empty($image)){
  $img = \App\Controllers\App::imageWithAlt($image);
  $img_type = \App\Controllers\App::checkImgExtension($image['filename']);
  }
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style
@endphp
<section data-{{ $block['id'] }} style="background-image: url({!! $img['image'] !!});" class="net-score">
  <div class="container">
    <div class="row">
      <div class="col-md-6 ">
        <h2>{!! $text !!}</h2>
      </div>
    </div>
  </div>
  <div class="img-wrap mobile-visible d-block d-xl-none">
    <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
    srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
  </div>
</section>
